/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jdiameter.common.api.app;

import org.jdiameter.api.ApplicationId;

/**
 * Interface for Application Session Data
 *
 * @author <a href="mailto:baranowb@gmail.com"> Bartosz Baranowski </a>
 * @author <a href="mailto:brainslog@gmail.com"> Alexandre Mendonca </a>
 */
public interface IAppSessionData {

  public static final int NON_INITIALIZED = Integer.MIN_VALUE; 

  /**
   * Returns the session-id of the session to which this data belongs to.
   * @return a string representing the session-id
   */
  public String getSessionId();

  /**
   * Sets the Application-Id of this Session Data session to which this data belongs to.
   * @param applicationId the Application-Id
   */
  public void setApplicationId(ApplicationId applicationId);

  /**
   * Returns the Application-Id of this Session Data session to which this data belongs to.
   * 
   * @return the Application-Id
   */
  public ApplicationId getApplicationId();

  /**
   * Removes this session data from storage
   * 
   * @return true if removed, false otherwise
   */
  public boolean remove();

}
