/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.io.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.transport.tcp.TCPClientConnection;
import org.jdiameter.common.api.concurrent.DummyConcurrentFactory;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.server.api.IMetaData;
import org.jdiameter.server.api.io.INetworkConnectionListener;
import org.jdiameter.server.api.io.INetworkGuard;
import org.jdiameter.server.impl.helpers.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkGuard
implements INetworkGuard {
    private static final Logger logger = LoggerFactory.getLogger(NetworkGuard.class);
    protected IMessageParser parser;
    protected IConcurrentFactory concurrentFactory;
    protected int port;
    protected long bindDelay;
    protected CopyOnWriteArrayList<INetworkConnectionListener> listeners = new CopyOnWriteArrayList();
    protected boolean isWork = false;
    private List<GuardTask> tasks = new ArrayList<GuardTask>();

    @Deprecated
    public NetworkGuard(InetAddress inetAddress, int port, IMessageParser parser) throws Exception {
        this(inetAddress, port, null, parser, null);
    }

    public NetworkGuard(InetAddress inetAddress, int port, IConcurrentFactory concurrentFactory, IMessageParser parser, IMetaData data) throws Exception {
        this(new InetAddress[]{inetAddress}, port, concurrentFactory, parser, data);
    }

    public NetworkGuard(InetAddress[] inetAddress, int port, IConcurrentFactory concurrentFactory, IMessageParser parser, IMetaData data) throws Exception {
        this.port = port;
        this.parser = parser;
        this.concurrentFactory = concurrentFactory == null ? new DummyConcurrentFactory() : concurrentFactory;
        this.bindDelay = data.getConfiguration().getLongValue(Parameters.BindDelay.ordinal(), ((Long)Parameters.BindDelay.defValue()).longValue());
        try {
            for (int addrIdx = 0; addrIdx < inetAddress.length; ++addrIdx) {
                GuardTask guardTask = new GuardTask(new InetSocketAddress(inetAddress[addrIdx], port));
                Thread t = this.concurrentFactory.getThread(guardTask);
                guardTask.thread = t;
                this.tasks.add(guardTask);
            }
            this.isWork = true;
            for (GuardTask gt : this.tasks) {
                gt.start();
            }
        }
        catch (Exception exc) {
            this.destroy();
            throw new Exception(exc);
        }
    }

    @Override
    public void addListener(INetworkConnectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void remListener(INetworkConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "NetworkGuard:" + (this.tasks.size() != 0 ? this.tasks : "closed");
    }

    @Override
    public void destroy() {
        this.isWork = false;
        Iterator<GuardTask> it = this.tasks.iterator();
        while (it.hasNext()) {
            GuardTask gt = it.next();
            it.remove();
            gt.cleanTask();
        }
    }

    private class GuardTask
    implements Runnable {
        private Thread thread;
        private Selector selector;
        private ServerSocket serverSocket;
        private final ScheduledExecutorService binder = Executors.newSingleThreadScheduledExecutor();

        GuardTask(final InetSocketAddress addr) throws IOException {
            if (NetworkGuard.this.bindDelay > 0L) {
                logger.info("Socket binding will be delayed by {}ms...", (Object)NetworkGuard.this.bindDelay);
            }
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.debug("Binding {} after delaying {}ms...", (Object)addr, (Object)NetworkGuard.this.bindDelay);
                        ServerSocketChannel ssc = ServerSocketChannel.open();
                        ssc.configureBlocking(false);
                        GuardTask.this.serverSocket = ssc.socket();
                        GuardTask.this.serverSocket.bind(addr);
                        GuardTask.this.selector = Selector.open();
                        ssc.register(GuardTask.this.selector, 16, addr);
                        logger.info("Open server socket {} ", (Object)GuardTask.this.serverSocket);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            this.binder.schedule(task, NetworkGuard.this.bindDelay, TimeUnit.MILLISECONDS);
        }

        public void start() {
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (NetworkGuard.this.isWork) {
                    if (this.selector == null) {
                        logger.trace("Selector is still null, stack is waiting for binding...");
                        Thread.sleep(250L);
                        continue;
                    }
                    int num = this.selector.select(100L);
                    if (num == 0) continue;
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    try {
                        for (SelectionKey key : keys) {
                            if ((key.readyOps() & 0x10) != 16) continue;
                            try {
                                Socket s = this.serverSocket.accept();
                                logger.info("Open incomming connection {}", (Object)s);
                                TCPClientConnection client = new TCPClientConnection(null, NetworkGuard.this.concurrentFactory, s, NetworkGuard.this.parser, null);
                                logger.debug("Finished initialising TCPClientConnection for {}", (Object)s);
                                for (INetworkConnectionListener listener : NetworkGuard.this.listeners) {
                                    listener.newNetworkConnection(client);
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Can not create incoming connection", (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.debug("Failed to accept connection,", (Throwable)e);
                    }
                    finally {
                        keys.clear();
                    }
                }
            }
            catch (Exception exc) {
                logger.warn("Server socket stopped", (Throwable)exc);
            }
        }

        public void cleanTask() {
            try {
                if (this.thread != null) {
                    this.thread.join(2000L);
                    if (this.thread.isAlive()) {
                        this.thread.interrupt();
                    }
                    this.thread = null;
                }
            }
            catch (InterruptedException e) {
                logger.debug("Can not stop thread", (Throwable)e);
            }
            if (this.selector != null) {
                try {
                    this.selector.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.selector = null;
            }
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.serverSocket = null;
            }
        }

        public String toString() {
            return "GuardTask [serverSocket=" + this.serverSocket + "]";
        }
    }
}

