/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.io.sctp;

import java.net.InetAddress;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.common.api.concurrent.DummyConcurrentFactory;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.server.api.IMetaData;
import org.jdiameter.server.api.io.INetworkConnectionListener;
import org.jdiameter.server.api.io.INetworkGuard;
import org.jdiameter.server.impl.io.sctp.SCTPServerConnection;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkGuard
implements INetworkGuard {
    private static final Logger logger = LoggerFactory.getLogger(NetworkGuard.class);
    protected IMessageParser parser;
    protected IConcurrentFactory concurrentFactory;
    protected int port;
    protected CopyOnWriteArrayList<INetworkConnectionListener> listeners = new CopyOnWriteArrayList();
    protected boolean isWork = false;
    protected Selector selector;
    protected List<SCTPServerConnection> serverConnections;
    protected InetAddress[] localAddresses;

    @Deprecated
    public NetworkGuard(InetAddress inetAddress, int port, IMessageParser parser) throws Exception {
        this(inetAddress, port, null, parser, null);
    }

    public NetworkGuard(InetAddress inetAddress, int port, IConcurrentFactory concurrentFactory, IMessageParser parser, IMetaData data) throws Exception {
        this(new InetAddress[]{inetAddress}, port, concurrentFactory, parser, data);
    }

    public NetworkGuard(InetAddress[] inetAddresses, int port, IConcurrentFactory concurrentFactory, IMessageParser parser, IMetaData data) throws Exception {
        this.port = port;
        this.localAddresses = inetAddresses;
        this.parser = parser;
        this.concurrentFactory = concurrentFactory == null ? new DummyConcurrentFactory() : concurrentFactory;
        this.serverConnections = new ArrayList<SCTPServerConnection>();
        try {
            for (InetAddress ia : inetAddresses) {
                SCTPServerConnection sctpServerConnection = new SCTPServerConnection(null, ia, port, parser, null, this);
                this.serverConnections.add(sctpServerConnection);
            }
        }
        catch (Exception exc) {
            try {
                this.destroy();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new Exception(exc);
        }
    }

    public void run() {
        try {
            while (this.isWork) {
                Thread.sleep(10000L);
            }
        }
        catch (Exception exc) {
            logger.warn("Server socket stopped", (Throwable)exc);
        }
    }

    @Override
    public void addListener(INetworkConnectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void remListener(INetworkConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "NetworkGuard:" + (this.serverConnections.size() != 0 ? this.serverConnections : "closed");
    }

    public void onNewRemoteConnection(Server globalServer, Association association, SCTPServerConnection connection) {
        logger.debug("New remote connection");
        try {
            String peerAddress = association.getPeerAddress();
            int peerPort = association.getPeerPort();
            String localAddress = association.getHostAddress();
            int localPort = association.getHostPort();
            SCTPServerConnection remoteClientConnection = new SCTPServerConnection(null, InetAddress.getByName(peerAddress), peerPort, InetAddress.getByName(localAddress), localPort, this.parser, null, this, globalServer, association, connection.getManagement());
            this.notifyListeners(remoteClientConnection);
        }
        catch (Exception exc) {
            logger.error("Error creating new remote connection");
        }
    }

    @Override
    public void destroy() {
        logger.debug("Destroying");
        Iterator<SCTPServerConnection> it = this.serverConnections.iterator();
        while (it.hasNext()) {
            try {
                SCTPServerConnection server = it.next();
                it.remove();
                if (server == null || !server.isConnected()) continue;
                server.disconnect();
                server.destroy();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    private void notifyListeners(SCTPServerConnection server) {
        for (INetworkConnectionListener listener : this.listeners) {
            try {
                listener.newNetworkConnection(server);
            }
            catch (Exception e) {
                logger.debug("Connection listener threw exception!", (Throwable)e);
            }
        }
    }
}

