/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownServiceException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.ConfigurationListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.MetaData;
import org.jdiameter.api.MutableConfiguration;
import org.jdiameter.api.MutablePeerTable;
import org.jdiameter.api.Network;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerState;
import org.jdiameter.api.PeerTableListener;
import org.jdiameter.api.Realm;
import org.jdiameter.api.Statistic;
import org.jdiameter.api.URI;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.api.StackState;
import org.jdiameter.client.api.controller.IRealm;
import org.jdiameter.client.api.fsm.EventTypes;
import org.jdiameter.client.api.fsm.IFsmFactory;
import org.jdiameter.client.api.io.IConnection;
import org.jdiameter.client.api.io.IConnectionListener;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.controller.PeerTableImpl;
import org.jdiameter.client.impl.helpers.AppConfiguration;
import org.jdiameter.client.impl.helpers.Ordinal;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.server.api.IMetaData;
import org.jdiameter.server.api.IMutablePeerTable;
import org.jdiameter.server.api.INetwork;
import org.jdiameter.server.api.IOverloadManager;
import org.jdiameter.server.api.IPeer;
import org.jdiameter.server.api.IRouter;
import org.jdiameter.server.api.io.INetworkConnectionListener;
import org.jdiameter.server.api.io.INetworkGuard;
import org.jdiameter.server.api.io.ITransportLayerFactory;
import org.jdiameter.server.impl.PeerImpl;
import org.jdiameter.server.impl.helpers.EmptyConfiguration;
import org.jdiameter.server.impl.helpers.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutablePeerTableImpl
extends PeerTableImpl
implements IMutablePeerTable,
ConfigurationListener {
    private static final Logger logger = LoggerFactory.getLogger(MutablePeerTableImpl.class);
    private static final int CONN_INVALIDATE_PERIOD = 60000;
    private static final int MAX_PEER_TABLE_SIZE = 10000;
    protected Configuration config;
    protected ISessionFactory sessionFactory;
    protected org.jdiameter.server.api.IFsmFactory fsmFactory;
    protected ITransportLayerFactory transportFactory;
    protected IMessageParser parser;
    protected IRouter router;
    protected boolean duplicateProtection = false;
    protected int duplicateSize;
    protected long duplicateTimer;
    protected ScheduledExecutorService duplicationScheduler = null;
    protected ScheduledFuture duplicationHandler = null;
    protected ConcurrentHashMap<String, StorageEntry> storageAnswers = new ConcurrentHashMap();
    protected boolean isAcceptUndefinedPeer = false;
    private ConcurrentHashMap<String, IConnection> incConnections;
    private ScheduledExecutorService connScheduler;
    private ScheduledFuture connHandler;
    protected INetworkGuard networkGuard;
    protected INetwork network;
    protected Set<String> predefinedPeerTable;
    protected IOverloadManager ovrManager;
    protected ScheduledExecutorService overloadScheduler = null;
    protected ScheduledFuture overloadHandler = null;
    protected PeerTableListener peerTableListener = null;
    protected IStatisticManager statisticFactory;
    private IContainer stack;
    private final Object regLock = new Object();

    public MutablePeerTableImpl(Configuration config, MetaData metaData, IContainer stack, IRouter router, ISessionFactory sessionFactory, org.jdiameter.server.api.IFsmFactory fsmFactory, ITransportLayerFactory trFactory, IMessageParser parser, INetwork network, IOverloadManager ovrManager, IStatisticManager statisticFactory, IConcurrentFactory concurrentFactory) {
        logger.debug("MutablePeerTableImpl is being created");
        this.metaData = metaData;
        this.config = config;
        this.router = router;
        this.sessionFactory = sessionFactory;
        this.statisticFactory = statisticFactory;
        this.concurrentFactory = concurrentFactory;
        this.fsmFactory = fsmFactory;
        this.transportFactory = trFactory;
        this.parser = parser;
        this.network = network;
        this.ovrManager = ovrManager;
        this.network.setPeerManager(this);
        this.stack = stack;
        this.isAcceptUndefinedPeer = config.getBooleanValue(Parameters.AcceptUndefinedPeer.ordinal(), false);
        this.duplicateProtection = config.getBooleanValue(Parameters.DuplicateProtection.ordinal(), ((Boolean)Parameters.DuplicateProtection.defValue()).booleanValue());
        if (this.duplicateProtection) {
            this.duplicateTimer = config.getLongValue(Parameters.DuplicateTimer.ordinal(), ((Long)Parameters.DuplicateTimer.defValue()).longValue());
            this.duplicateSize = config.getIntValue(Parameters.DuplicateSize.ordinal(), ((Integer)Parameters.DuplicateSize.defValue()).intValue());
        }
        logger.debug("Duplicate Protection Configuration: Enabled? {}, Timer: {}, Size: {}", new Object[]{this.duplicateProtection, this.duplicateTimer, this.duplicateSize});
        if (this.predefinedPeerTable == null) {
            this.predefinedPeerTable = new CopyOnWriteArraySet<String>();
        }
        if (config instanceof MutableConfiguration) {
            ((MutableConfiguration)config).addChangeListener((ConfigurationListener)this, new int[0]);
        }
        logger.debug("MutablePeerTableImpl is starting initialisation by calling init on super class");
        this.init(stack, router, config, metaData, fsmFactory, this.transportFactory, statisticFactory, concurrentFactory, parser);
        logger.debug("MutablePeerTableImpl has finished initialisation");
    }

    @Override
    protected Peer createPeer(int rating, String uri, String ip, String portRange, MetaData metaData, Configuration globalConfig, Configuration peerConfig, IFsmFactory fsmFactory, org.jdiameter.client.api.io.ITransportLayerFactory transportFactory, IStatisticManager statisticFactory, IConcurrentFactory concurrentFactory, IMessageParser parser) throws InternalException, TransportException, URISyntaxException, UnknownServiceException {
        logger.debug("Creating Peer for URI [{}]", (Object)uri);
        if (this.predefinedPeerTable == null) {
            logger.debug("Creating new empty predefined peer table");
            this.predefinedPeerTable = new CopyOnWriteArraySet<String>();
        }
        logger.debug("Adding URI [{}] to predefinedPeerTable", (Object)uri);
        this.predefinedPeerTable.add(new URI(uri).getFQDN());
        if (peerConfig.getBooleanValue(Parameters.PeerAttemptConnection.ordinal(), false)) {
            logger.debug("Peer at URI [{}] is configured to attempt a connection (acting as a client) and a new peer instance will be created and returned", (Object)uri);
            return this.newPeerInstance(rating, new URI(uri), ip, portRange, true, null, metaData, globalConfig, peerConfig, (org.jdiameter.server.api.IFsmFactory)fsmFactory, (ITransportLayerFactory)transportFactory, parser, statisticFactory, concurrentFactory);
        }
        logger.debug("Peer at URI [{}] is configured to NOT attempt a connection (i.e. acting as a server) and null will be returned", (Object)uri);
        return null;
    }

    protected IPeer newPeerInstance(int rating, URI uri, String ip, String portRange, boolean attCnn, IConnection connection, MetaData metaData, Configuration globalConfig, Configuration peerConfig, org.jdiameter.server.api.IFsmFactory fsmFactory, ITransportLayerFactory transportFactory, IMessageParser parser, IStatisticManager statisticFactory, IConcurrentFactory concurrentFactory) throws URISyntaxException, UnknownServiceException, InternalException, TransportException {
        logger.debug("Creating and returning a new Peer Instance for URI [{}].", (Object)uri);
        return new PeerImpl(rating, uri, ip, portRange, attCnn, connection, this, (IMetaData)metaData, globalConfig, peerConfig, this.sessionFactory, fsmFactory, transportFactory, statisticFactory, concurrentFactory, parser, this.network, this.ovrManager, this.sessionDatasource);
    }

    public void setPeerTableListener(PeerTableListener peerTableListener) {
        this.peerTableListener = peerTableListener;
    }

    public boolean elementChanged(int i, Object data) {
        Configuration newConf = (Configuration)data;
        this.stopTimeOut = newConf.getLongValue(org.jdiameter.client.impl.helpers.Parameters.StopTimeOut.ordinal(), ((Long)org.jdiameter.client.impl.helpers.Parameters.StopTimeOut.defValue()).longValue());
        this.duplicateTimer = newConf.getLongValue(Parameters.DuplicateTimer.ordinal(), ((Long)Parameters.DuplicateTimer.defValue()).longValue());
        this.isAcceptUndefinedPeer = newConf.getBooleanValue(Parameters.AcceptUndefinedPeer.ordinal(), false);
        return true;
    }

    public boolean isDuplicateProtection() {
        return this.duplicateProtection;
    }

    @Override
    public void start() throws IllegalDiameterStateException, IOException {
        logger.debug("Starting MutablePeerTableImpl. Starting router, overload scheduler, connection check timer, etc.");
        this.router.start();
        this.overloadScheduler = this.concurrentFactory.getScheduledExecutorService(IConcurrentFactory.ScheduledExecServices.PeerOverloadTimer.name());
        Runnable overloadTask = new Runnable(){

            @Override
            public void run() {
                if (MutablePeerTableImpl.this.ovrManager != null) {
                    for (Peer p : MutablePeerTableImpl.this.peerTable.values()) {
                        ((IPeer)p).notifyOvrManager(MutablePeerTableImpl.this.ovrManager);
                    }
                }
            }
        };
        this.overloadHandler = this.overloadScheduler.scheduleAtFixedRate(overloadTask, 0L, 1L, TimeUnit.SECONDS);
        if (this.duplicateProtection) {
            this.duplicationScheduler = this.concurrentFactory.getScheduledExecutorService(IConcurrentFactory.ScheduledExecServices.DuplicationMessageTimer.name());
            Runnable duplicateTask = new Runnable(){

                @Override
                public void run() {
                    long now = System.currentTimeMillis();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Running Duplicate Cleaning Task. Duplicate Storage size is: {}. Removing entries with time <= '{}'", (Object)MutablePeerTableImpl.this.storageAnswers.size(), (Object)(now - MutablePeerTableImpl.this.duplicateTimer));
                    }
                    for (StorageEntry s : MutablePeerTableImpl.this.storageAnswers.values()) {
                        if (s != null && s.getTime() + MutablePeerTableImpl.this.duplicateTimer <= now) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("Duplicate Cleaning Task - Removing Entry with key '{}' and time '{}'", (Object)s.getDuplicationKey(), (Object)s.getTime());
                            }
                            MutablePeerTableImpl.this.storageAnswers.remove(s.getDuplicationKey());
                            continue;
                        }
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Duplicate Cleaning Task - Skipping Entry with key '{}' and time '{}'", (Object)s.getDuplicationKey(), (Object)s.getTime());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Completed Duplicate Cleaning Task. New Duplicate Storage size is: {}. Total task runtime: {}ms", (Object)MutablePeerTableImpl.this.storageAnswers.size(), (Object)(System.currentTimeMillis() - now));
                    }
                }
            };
            this.duplicationHandler = this.duplicationScheduler.scheduleAtFixedRate(duplicateTask, this.duplicateTimer, this.duplicateTimer, TimeUnit.MILLISECONDS);
        }
        this.connScheduler = this.concurrentFactory.getScheduledExecutorService(IConcurrentFactory.ScheduledExecServices.ConnectionTimer.name());
        Runnable connectionCheckTask = new Runnable(){

            @Override
            public void run() {
                ConcurrentHashMap<String, IConnection> connections = MutablePeerTableImpl.this.getIncConnections();
                for (IConnection connection : connections.values()) {
                    if (System.currentTimeMillis() - connection.getCreatedTime() < 60000L) continue;
                    logger.debug("External connection released by timeout [{}]", (Object)connection.getKey());
                    try {
                        connection.remAllConnectionListener();
                        connection.release();
                    }
                    catch (IOException e) {
                        logger.debug("Unable to release connection", (Throwable)e);
                    }
                    connections.remove(connection.getKey());
                }
            }
        };
        this.connHandler = this.connScheduler.scheduleAtFixedRate(connectionCheckTask, 60000L, 60000L, TimeUnit.MILLISECONDS);
        try {
            logger.debug("Creating network guard");
            this.networkGuard = this.createNetworkGuard(this.transportFactory);
        }
        catch (TransportException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            Peer p = this.stack.getMetaData().getLocalPeer();
            String ips = "";
            for (InetAddress ip : p.getIPAddresses()) {
                ips = ips + " " + ip.getHostAddress() + ":" + p.getUri().getPort();
            }
            logger.error("Unable to create server socket for LocalPeer '{}' at{} ({}).", new Object[]{p.getUri().getFQDN(), ips, t.getMessage()});
            logger.debug("Unable to create server socket", (Throwable)e);
        }
        for (Peer p : this.peerTable.values()) {
            try {
                if (!((IPeer)p).isAttemptConnection()) continue;
                p.connect();
            }
            catch (Exception e) {
                logger.warn("Unable to start connect procedure for peer [" + p + "]", (Throwable)e);
            }
        }
        this.isStarted = true;
    }

    public Set<String> getPredefinedPeerTable() {
        return this.predefinedPeerTable;
    }

    public ConcurrentHashMap<String, IConnection> getIncConnections() {
        if (this.incConnections == null) {
            this.incConnections = new ConcurrentHashMap();
        }
        return this.incConnections;
    }

    private INetworkGuard createNetworkGuard(final ITransportLayerFactory transportFactory) throws TransportException {
        return transportFactory.createNetworkGuard(this.metaData.getLocalPeer().getIPAddresses(), this.metaData.getLocalPeer().getUri().getPort(), new INetworkConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void newNetworkConnection(final IConnection connection) {
                logger.debug("newNetworkConnection. connection [{}]", (Object)connection.getKey());
                Object object = MutablePeerTableImpl.this.regLock;
                synchronized (object) {
                    IConnectionListener listener = new IConnectionListener(){

                        @Override
                        public void connectionOpened(String connKey) {
                            logger.debug("Connection [{}] opened", (Object)connKey);
                        }

                        @Override
                        public void connectionClosed(String connKey, List notSended) {
                            logger.debug("Connection [{}] closed", (Object)connKey);
                            this.unregister(true);
                        }

                        @Override
                        public void messageReceived(String connKey, IMessage message) {
                            logger.debug("Message [{}] received to peer [{}]", (Object)message, (Object)connKey);
                            if (message.isRequest() && message.getCommandCode() == 257) {
                                String realm;
                                String host;
                                connection.remConnectionListener(this);
                                IPeer peer = null;
                                try {
                                    host = message.getAvps().getAvp(264).getDiameterIdentity();
                                    logger.debug("Origin-Host in new received message is [{}]", (Object)host);
                                }
                                catch (AvpDataException e) {
                                    logger.warn("Unable to retrieve find Origin-Host AVP in CER", (Throwable)e);
                                    this.unregister(true);
                                    return;
                                }
                                try {
                                    realm = message.getAvps().getAvp(296).getDiameterIdentity();
                                    logger.debug("Origin-Realm in new received message is [{}]", (Object)realm);
                                }
                                catch (AvpDataException e) {
                                    logger.warn("Unable to retrieve find Origin-Realm AVP in CER", (Throwable)e);
                                    this.unregister(true);
                                    return;
                                }
                                boolean foundInPredefinedTable = false;
                                for (String fqdn : MutablePeerTableImpl.this.predefinedPeerTable) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("Checking against entry in predefinedPeerTable with FQDN [{}]", (Object)fqdn);
                                    }
                                    if (fqdn.equals(host)) {
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("{} == {}", (Object)fqdn, (Object)host);
                                        }
                                        peer = (IPeer)MutablePeerTableImpl.this.peerTable.get(fqdn);
                                        foundInPredefinedTable = true;
                                        break;
                                    }
                                    if (!logger.isDebugEnabled()) continue;
                                    logger.debug("{} != {}", (Object)fqdn, (Object)host);
                                }
                                if (peer == null) {
                                    logger.debug("Peer with FQDN [{}] was not found in predefined peer table. Checking at (previously) connected peers table", (Object)host);
                                    peer = (IPeer)MutablePeerTableImpl.this.peerTable.get(host);
                                    if (peer != null) {
                                        logger.debug("Got peer for FQDN [{}]. Is connection open ? {}.", (Object)host, (Object)peer.hasValidConnection());
                                    } else {
                                        logger.debug("Still haven't found peer for FQDN [{}]", (Object)host);
                                    }
                                }
                                if (peer != null) {
                                    logger.debug("Add [{}] connection to peer [{}]", (Object)connection, peer);
                                    peer.addIncomingConnection(connection);
                                    try {
                                        logger.debug("Handle [{}] message on peer [{}]", (Object)message, (Object)peer);
                                        peer.handleMessage(message.isRequest() ? EventTypes.CER_EVENT : EventTypes.CER_EVENT, message, connKey);
                                    }
                                    catch (Exception e) {
                                        logger.debug("Unable to process CER message", (Throwable)e);
                                    }
                                } else if (MutablePeerTableImpl.this.isAcceptUndefinedPeer || foundInPredefinedTable) {
                                    try {
                                        int port = connection.getRemotePort();
                                        boolean hostAsUri = MutablePeerTableImpl.this.config.getBooleanValue(org.jdiameter.client.impl.helpers.Parameters.UseUriAsFqdn.ordinal(), ((Boolean)org.jdiameter.client.impl.helpers.Parameters.UseUriAsFqdn.defValue()).booleanValue());
                                        URI uri = hostAsUri || host.startsWith("aaa://") ? new URI(host) : new URI("aaa://" + host + ":" + port);
                                        peer = MutablePeerTableImpl.this.newPeerInstance(0, uri, connection.getRemoteAddress().getHostAddress(), null, false, connection, MutablePeerTableImpl.this.metaData, MutablePeerTableImpl.this.config, null, MutablePeerTableImpl.this.fsmFactory, transportFactory, MutablePeerTableImpl.this.parser, MutablePeerTableImpl.this.statisticFactory, MutablePeerTableImpl.this.concurrentFactory);
                                        logger.debug("Created new peer instance [{}] and adding to peer table", (Object)peer);
                                        peer.setRealm(realm);
                                        MutablePeerTableImpl.this.appendPeerToPeerTable(peer);
                                        logger.debug("Handle [{}] message on peer [{}]", (Object)message, (Object)peer);
                                        peer.handleMessage(message.isRequest() ? EventTypes.CER_EVENT : EventTypes.CER_EVENT, message, connKey);
                                    }
                                    catch (Exception e) {
                                        logger.warn("Unable to create peer", (Throwable)e);
                                        this.unregister(true);
                                    }
                                } else {
                                    logger.info("Skip anonymous connection [{}]", (Object)connection);
                                    this.unregister(true);
                                }
                            } else {
                                logger.debug("Unknown message [{}] by connection [{}]", (Object)message, (Object)connKey);
                                this.unregister(true);
                            }
                        }

                        @Override
                        public void internalError(String connKey, IMessage message, TransportException cause) {
                            logger.debug("Connection [{}] internalError [{}]", (Object)connKey, (Object)cause);
                            this.unregister(true);
                        }

                        public void unregister(boolean release) {
                            MutablePeerTableImpl.this.getIncConnections().remove(connection.getKey());
                            connection.remConnectionListener(this);
                            if (release && connection.isConnected()) {
                                try {
                                    connection.release();
                                }
                                catch (IOException e) {
                                    logger.debug("Unable to release connection [{}]", (Object)connection);
                                }
                            }
                        }
                    };
                    String connKey = connection.getKey();
                    MutablePeerTableImpl.this.getIncConnections().put(connection.getKey(), connection);
                    logger.debug("Inserted connection [{}] into IncConnections", (Object)connKey);
                    connection.addConnectionListener(listener);
                    logger.debug("Added listener [{}] to connection [{}]", (Object)listener, (Object)connKey);
                }
            }
        });
    }

    private void appendPeerToPeerTable(IPeer peer) {
        logger.debug("Adding Peer[{}] to PeerTable with size {}", (Object)peer, (Object)this.peerTable.size());
        if (this.peerTable.size() == 10000) {
            for (String k : this.peerTable.keySet()) {
                Peer p = (Peer)this.peerTable.get(k);
                if (p == null || p.getState(PeerState.class) != PeerState.DOWN) continue;
                this.peerTable.remove(k, p);
            }
        }
        this.peerTable.put(peer.getUri().getFQDN(), peer);
        if (this.peerTableListener != null) {
            this.peerTableListener.peerAccepted((Peer)peer);
        }
    }

    @Override
    public void stopping(int disconnectCause) {
        super.stopping(disconnectCause);
        if (this.networkGuard != null) {
            this.networkGuard.destroy();
            this.networkGuard = null;
        }
        if (this.overloadScheduler != null) {
            this.concurrentFactory.shutdownNow(this.overloadScheduler);
            this.overloadScheduler = null;
            this.overloadHandler.cancel(true);
            this.overloadHandler = null;
        }
        if (this.duplicationScheduler != null) {
            this.concurrentFactory.shutdownNow(this.duplicationScheduler);
            this.duplicationScheduler = null;
        }
        if (this.duplicationHandler != null) {
            this.duplicationHandler.cancel(true);
            this.duplicationHandler = null;
        }
        if (this.connScheduler != null) {
            this.concurrentFactory.shutdownNow(this.connScheduler);
            this.connScheduler = null;
        }
        if (this.connHandler != null) {
            this.connHandler.cancel(true);
            this.connHandler = null;
        }
        this.storageAnswers.clear();
        Iterator it = this.peerTable.keySet().iterator();
        while (it.hasNext()) {
            String fqdn = (String)it.next();
            if (this.predefinedPeerTable.contains(fqdn)) continue;
            it.remove();
        }
    }

    public Peer addPeer(URI peerURI, String realm, boolean connecting) {
        try {
            IPeer peer;
            Configuration[] peers;
            AppConfiguration peerConfig = null;
            for (Configuration c : peers = this.config.getChildren(org.jdiameter.client.impl.helpers.Parameters.PeerTable.ordinal())) {
                if (!peerURI.getFQDN().equals(c.getStringValue(org.jdiameter.client.impl.helpers.Parameters.PeerName.ordinal(), ""))) continue;
                peerConfig = c;
                break;
            }
            if (peerConfig == null) {
                peerConfig = new EmptyConfiguration(false).add((Ordinal)Parameters.PeerAttemptConnection, connecting);
            }
            if ((peer = (IPeer)this.createPeer(0, peerURI.toString(), null, null, this.metaData, this.config, peerConfig, this.fsmFactory, this.transportFactory, this.statisticFactory, this.concurrentFactory, this.parser)) == null) {
                return null;
            }
            peer.setRealm(realm);
            this.appendPeerToPeerTable(peer);
            boolean found = false;
            Collection<Realm> realms = this.router.getRealmTable().getRealms(realm);
            for (Realm r : realms) {
                if (!r.getName().equals(realm)) continue;
                ((IRealm)r).addPeerName(peerURI.toString());
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("Incorrect realm name");
            }
            if (StackState.STARTED.equals((Object)this.stack.getState()) && connecting) {
                peer.connect();
            }
            return peer;
        }
        catch (Exception e) {
            logger.debug("Unable to add peer", (Throwable)e);
            return null;
        }
    }

    public Set<Realm> getAllRealms() {
        return new HashSet<Realm>(this.router.getRealmTable().getRealms());
    }

    public Peer removePeer(String host) {
        try {
            String fqdn = null;
            for (String f : this.peerTable.keySet()) {
                if (!f.equals(host)) continue;
                fqdn = f;
                ((Peer)this.peerTable.get(fqdn)).disconnect(1);
            }
            if (fqdn != null) {
                this.predefinedPeerTable.remove(fqdn);
                Peer removedPeer = (Peer)this.peerTable.remove(fqdn);
                if (this.peerTableListener != null) {
                    this.peerTableListener.peerRemoved(removedPeer);
                }
                return removedPeer;
            }
            return null;
        }
        catch (Exception e) {
            logger.debug("Unable to remove peer", (Throwable)e);
            return null;
        }
    }

    public Statistic getStatistic(String name) {
        for (Peer p : this.peerTable.values()) {
            if (!p.getUri().getFQDN().equals(name)) continue;
            return ((IPeer)p).getStatistic();
        }
        return null;
    }

    @Override
    public IMessage isDuplicate(IMessage request) {
        String key = request.getDuplicationKey();
        if (key != null && this.storageAnswers != null) {
            StorageEntry entry = this.storageAnswers.get(key);
            return entry != null ? (IMessage)entry.getMessage().clone() : null;
        }
        return null;
    }

    @Override
    public void saveToDuplicate(String key, IMessage answer) {
        if (this.storageAnswers != null && this.storageAnswers.size() < this.duplicateSize && key != null) {
            StorageEntry se = new StorageEntry((IMessage)answer.clone());
            if (logger.isTraceEnabled()) {
                logger.trace("Duplicate Protection - Inserting Entry with key '{}' and time '{}'", (Object)key, (Object)se.getTime());
            }
            this.storageAnswers.put(key, se);
        }
    }

    @Override
    public ISessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        boolean isWrapp = super.isWrapperFor(aClass);
        return aClass == MutablePeerTable.class || aClass == Network.class || isWrapp;
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws InternalException {
        if (aClass == MutablePeerTable.class) {
            return this.assembler.getComponentInstance(aClass);
        }
        if (aClass == Network.class) {
            return this.assembler.getComponentInstance(aClass);
        }
        return null;
    }

    protected class StorageEntry {
        private String duplicationKey;
        private long time = System.currentTimeMillis();
        private IMessage answer;

        public StorageEntry(IMessage message) {
            this.answer = message;
            String[] originInfo = MutablePeerTableImpl.this.router.getRequestRouteInfo(this.answer);
            this.duplicationKey = message.getDuplicationKey(originInfo[0], message.getEndToEndIdentifier());
        }

        public IMessage getMessage() {
            return this.answer;
        }

        public long getTime() {
            return this.time;
        }

        public String getDuplicationKey() {
            return this.duplicationKey;
        }
    }
}

