/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl;

import org.jdiameter.api.AvpSet;
import org.jdiameter.client.api.IMessage;

public class MessageValidator {
    public static final Result SUCCESS = new Result(null, 2001L);
    private boolean enable = true;

    public void enable() {
        this.enable = true;
    }

    public void disable() {
        this.enable = false;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public Result check(IMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        if (!this.enable) {
            return SUCCESS;
        }
        return null;
    }

    public static class Result {
        private IMessage errorMessage;
        private long code = 2001L;

        Result(IMessage errorMessage, long code) {
            this.errorMessage = errorMessage;
            this.code = code;
        }

        public boolean isOK() {
            return this.code == 2001L || this.code == 2002L;
        }

        public long toLong() {
            return this.code;
        }

        public IMessage toMessage() {
            if (this.errorMessage != null && this.errorMessage.getAvps().getAvp(268) == null) {
                this.errorMessage.getAvps().addAvp(268, this.code);
            }
            return this.errorMessage;
        }

        public IMessage toMessage(int vendorId) {
            if (this.errorMessage != null && this.errorMessage.getAvps().getAvp(297) == null) {
                AvpSet er = this.errorMessage.getAvps().addGroupedAvp(297);
                er.addAvp(266, vendorId);
                er.addAvp(298, this.code);
            }
            return this.errorMessage;
        }
    }
}

