/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.statistic;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.jdiameter.api.StatisticRecord;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticRecord;

class StatisticImpl
implements IStatistic {
    protected boolean enable = true;
    protected ConcurrentLinkedQueue<StatisticRecord> records = new ConcurrentLinkedQueue();
    protected String name;
    protected String description;
    protected IStatistic.Groups group;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    StatisticImpl(String name) {
        this.name = name;
    }

    StatisticImpl(String name, IStatistic.Groups group) {
        this(group.name() + "." + name);
        this.group = group;
        this.description = group.getDescription();
    }

    StatisticImpl(String name, IStatistic.Groups group, String desctiprion, IStatisticRecord ... rec) {
        this(name, group);
        this.description = desctiprion;
        for (IStatisticRecord r : rec) {
            this.records.add(r);
        }
    }

    @Override
    public void appendCounter(IStatisticRecord ... rec) {
        for (IStatisticRecord r : rec) {
            r.enable(this.enable);
            this.records.add(r);
        }
    }

    @Override
    public IStatisticRecord getRecordByName(String name) {
        for (StatisticRecord r : this.records) {
            if (!r.getName().equals(name)) continue;
            return (IStatisticRecord)r;
        }
        return null;
    }

    @Override
    public IStatisticRecord getRecordByName(IStatisticRecord.Counters name) {
        for (StatisticRecord r : this.records) {
            if (!r.getName().equals(name.toString())) continue;
            return (IStatisticRecord)r;
        }
        return null;
    }

    public void enable(boolean e) {
        for (StatisticRecord r : this.records) {
            r.enable(e);
        }
        this.enable = e;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void reset() {
        for (StatisticRecord r : this.records) {
            r.reset();
        }
    }

    public StatisticRecord[] getRecords() {
        return this.records.toArray(new StatisticRecord[0]);
    }

    public String toString() {
        return "Statistic{ records=" + this.records + " }";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatisticImpl other = (StatisticImpl)obj;
        if (this.group != other.group) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

