/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.cxdx;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateMachine;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.cxdx.ICxDxMessageFactory;
import org.jdiameter.common.api.app.cxdx.ICxDxSessionData;
import org.jdiameter.common.impl.app.AppSessionImpl;

public abstract class CxDxSession
extends AppSessionImpl
implements NetworkReqListener,
StateMachine {
    public static final int _TX_TIMEOUT = 30000;
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient List<StateChangeListener> stateListeners = new CopyOnWriteArrayList<StateChangeListener>();
    protected transient ICxDxMessageFactory messageFactory;
    protected static final String TIMER_NAME_MSG_TIMEOUT = "MSG_TIMEOUT";
    protected ICxDxSessionData sessionData;

    public CxDxSession(ISessionFactory sf, ICxDxSessionData sessionData) {
        super(sf, sessionData);
        this.sessionData = sessionData;
    }

    public void addStateChangeNotification(StateChangeListener listener) {
        if (!this.stateListeners.contains(listener)) {
            this.stateListeners.add(listener);
        }
    }

    public void removeStateChangeNotification(StateChangeListener listener) {
        this.stateListeners.remove(listener);
    }

    public boolean isStateless() {
        return true;
    }

    @Override
    public boolean isReplicable() {
        return false;
    }

    @Override
    public void release() {
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMsgTimer() {
        try {
            this.sendAndStateLock.lock();
            this.sessionData.setTsTimerId(this.timerFacility.schedule(this.getSessionId(), TIMER_NAME_MSG_TIMEOUT, 30000L));
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelMsgTimer() {
        try {
            this.sendAndStateLock.lock();
            Serializable timerId = this.sessionData.getTsTimerId();
            if (timerId == null) {
                return;
            }
            this.timerFacility.cancel(timerId);
            this.sessionData.setTsTimerId(null);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CxDxSession other = (CxDxSession)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }
}

