/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tls;

import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jdiameter.api.Configuration;
import org.jdiameter.client.impl.helpers.Parameters;

public class TLSUtils {
    public static SSLContext getSecureContext(Configuration sslConfig) throws Exception {
        String contextTransportAlgo = sslConfig.getStringValue(Parameters.SDProtocol.ordinal(), null);
        Configuration kdConfig = sslConfig.getChildren(Parameters.KeyData.ordinal())[0];
        Configuration tdConfig = sslConfig.getChildren(Parameters.TrustData.ordinal())[0];
        String keyManagerAlgo = kdConfig.getStringValue(Parameters.KDManager.ordinal(), null);
        String keyStoreType = kdConfig.getStringValue(Parameters.KDStore.ordinal(), null);
        String keyStorePassword = kdConfig.getStringValue(Parameters.KDPwd.ordinal(), null);
        String keyStoreFile = kdConfig.getStringValue(Parameters.KDFile.ordinal(), null);
        String trustManagerAlgo = tdConfig.getStringValue(Parameters.TDManager.ordinal(), null);
        String trustStoreType = tdConfig.getStringValue(Parameters.TDStore.ordinal(), null);
        String trustStorePassword = tdConfig.getStringValue(Parameters.TDPwd.ordinal(), null);
        String trustStoreFile = tdConfig.getStringValue(Parameters.TDFile.ordinal(), null);
        return TLSUtils.getSecureContext(contextTransportAlgo, keyManagerAlgo, keyStoreType, keyStorePassword, keyStoreFile, trustManagerAlgo, trustStoreType, trustStorePassword, trustStoreFile);
    }

    public static SSLContext getSecureContext(String contextTransportAlgo, String keyManagerAlgo, String keyStoreType, String keyStorePassword, String keyStoreFile, String trustManagerAlgo, String trustStoreType, String trustStorePassword, String trustStoreFile) throws Exception {
        System.err.println(KeyManagerFactory.getDefaultAlgorithm());
        System.err.println(TrustManagerFactory.getDefaultAlgorithm());
        SSLContext ctx = SSLContext.getInstance(contextTransportAlgo);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgo);
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        char[] key = keyStorePassword.toCharArray();
        keyStore.load(new FileInputStream(keyStoreFile), key);
        keyManagerFactory.init(keyStore, key);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerAlgo);
        KeyStore trustKeyStore = KeyStore.getInstance(trustStoreType);
        char[] trustKey = trustStorePassword.toCharArray();
        trustKeyStore.load(new FileInputStream(trustStoreFile), trustKey);
        trustManagerFactory.init(trustKeyStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        ctx.init(keyManagers, trustManagers, null);
        return ctx;
    }

    public static Configuration getSSLConfiguration(Configuration cnf, String ref) {
        Configuration[] sec;
        for (Configuration i : sec = cnf.getChildren(Parameters.Security.ordinal())) {
            if (!i.getStringValue(Parameters.SDName.ordinal(), "").equals(ref)) continue;
            return i;
        }
        return null;
    }
}

