/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.parser;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.client.api.parser.IElementParser;
import org.jdiameter.client.api.parser.ParseException;
import org.jdiameter.client.impl.parser.AvpImpl;
import org.jdiameter.client.impl.parser.AvpSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementParser
implements IElementParser {
    private static final Logger logger = LoggerFactory.getLogger(ElementParser.class);
    private static final long SECOND_SHIFT = 2208988800L;
    private static final int INT_INET4 = 1;
    private static final int INT_INET6 = 2;
    private static final int INT32_SIZE = 4;
    private static final int INT64_SIZE = 8;

    @Override
    public int bytesToInt(byte[] rawData) throws AvpDataException {
        return (rawData[0] & 0xFF) << 24 | (rawData[1] & 0xFF) << 16 | (rawData[2] & 0xFF) << 8 | (rawData[3] & 0xFF) << 0;
    }

    @Override
    public long bytesToLong(byte[] rawData) throws AvpDataException {
        return ((long)rawData[0] & 0xFFL) << 56 | ((long)rawData[1] & 0xFFL) << 48 | ((long)rawData[2] & 0xFFL) << 40 | ((long)rawData[3] & 0xFFL) << 32 | ((long)rawData[4] & 0xFFL) << 24 | ((long)rawData[5] & 0xFFL) << 16 | ((long)rawData[6] & 0xFFL) << 8 | ((long)rawData[7] & 0xFFL) << 0;
    }

    public long bytesToUnsignedInt32(byte[] rawData) throws AvpDataException {
        byte[] u32ext = new byte[8];
        System.arraycopy(rawData, 0, u32ext, 4, 4);
        return this.bytesToLong(u32ext);
    }

    @Override
    public float bytesToFloat(byte[] rawData) throws AvpDataException {
        return Float.intBitsToFloat(this.bytesToInt(rawData));
    }

    @Override
    public double bytesToDouble(byte[] rawData) throws AvpDataException {
        return Double.longBitsToDouble(this.bytesToLong(rawData));
    }

    @Override
    public String bytesToOctetString(byte[] rawData) throws AvpDataException {
        try {
            return new String(rawData, "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new AvpDataException("Invalid data type", (Throwable)e);
        }
    }

    @Override
    public String bytesToUtf8String(byte[] rawData) throws AvpDataException {
        try {
            return new String(rawData, "utf8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AvpDataException("Invalid data type", (Throwable)e);
        }
    }

    @Override
    public Date bytesToDate(byte[] rawData) throws AvpDataException {
        try {
            byte[] tmp = new byte[8];
            System.arraycopy(rawData, 0, tmp, 4, 4);
            return new Date((this.bytesToLong(tmp) - 2208988800L) * 1000L);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e);
        }
    }

    @Override
    public InetAddress bytesToAddress(byte[] rawData) throws AvpDataException {
        InetAddress inetAddress;
        try {
            boolean isIPv6 = rawData[1] != 1;
            byte[] address = new byte[isIPv6 ? 16 : 4];
            System.arraycopy(rawData, 2, address, 0, address.length);
            inetAddress = isIPv6 ? InetAddress.getByAddress(address) : InetAddress.getByAddress(address);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e);
        }
        return inetAddress;
    }

    @Override
    public byte[] int32ToBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 0 & 0xFF)};
        return bytes;
    }

    @Override
    public byte[] intU32ToBytes(long value) {
        byte[] bytes = this.int64ToBytes(value);
        return new byte[]{bytes[4], bytes[5], bytes[6], bytes[7]};
    }

    @Override
    public byte[] int64ToBytes(long value) {
        byte[] bytes = new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 0 & 0xFFL)};
        return bytes;
    }

    @Override
    public byte[] float32ToBytes(float value) {
        return this.int32ToBytes(Float.floatToIntBits(value));
    }

    @Override
    public byte[] float64ToBytes(double value) {
        return this.int64ToBytes(Double.doubleToLongBits(value));
    }

    @Override
    public byte[] octetStringToBytes(String value) throws ParseException {
        try {
            return value.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public byte[] utf8StringToBytes(String value) throws ParseException {
        try {
            return value.getBytes("utf8");
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public byte[] addressToBytes(InetAddress address) {
        byte[] byteAddrOrig = address.getAddress();
        byte[] data = new byte[byteAddrOrig.length + 2];
        int addrType = address instanceof Inet4Address ? 1 : 2;
        data[0] = (byte)(addrType >> 8 & 0xFF);
        data[1] = (byte)(addrType >> 0 & 0xFF);
        System.arraycopy(byteAddrOrig, 0, data, 2, byteAddrOrig.length);
        return data;
    }

    @Override
    public byte[] dateToBytes(Date date) {
        byte[] data = new byte[4];
        System.arraycopy(this.int64ToBytes(date.getTime() / 1000L + 2208988800L), 4, data, 0, 4);
        return data;
    }

    @Override
    public <T> T bytesToObject(Class<?> iface, byte[] rawdata) throws AvpDataException {
        return null;
    }

    @Override
    public byte[] objectToBytes(Object data) throws ParseException {
        return null;
    }

    public AvpSetImpl decodeAvpSet(byte[] buffer) throws IOException, AvpDataException {
        return this.decodeAvpSet(buffer, 0);
    }

    public AvpSetImpl decodeAvpSet(byte[] buffer, int shift) throws IOException, AvpDataException {
        int length;
        AvpSetImpl avps = new AvpSetImpl();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer, shift, buffer.length));
        for (int counter = shift; counter < buffer.length; counter += length) {
            int code = in.readInt();
            int tmp = in.readInt();
            int flags = tmp >> 24 & 0xFF;
            length = tmp & 0xFFFFFF;
            if (length < 0 || counter + length > buffer.length) {
                throw new AvpDataException("Not enough data in buffer!");
            }
            long vendor = 0L;
            if ((flags & 0x80) != 0) {
                vendor = in.readInt();
            }
            byte[] rawData = new byte[length - (8 + (vendor == 0L ? 0 : 4))];
            in.read(rawData);
            if (length % 4 != 0) {
                while (length % 4 != 0) {
                    int i = (int)in.skip(4 - length % 4);
                    length += i;
                }
            }
            AvpImpl avp = new AvpImpl(code, (short)flags, (int)vendor, rawData);
            avps.addAvp(avp);
        }
        return avps;
    }

    public byte[] encodeAvpSet(AvpSet avps) {
        DynamicByteArray dba = new DynamicByteArray(0);
        try {
            for (Avp a : avps) {
                if (!(a instanceof AvpImpl)) continue;
                AvpImpl aImpl = (AvpImpl)a;
                if (aImpl.rawData.length == 0 && aImpl.groupedData != null) {
                    aImpl.rawData = this.encodeAvpSet(a.getGrouped());
                }
                dba.add(this.encodeAvp(aImpl));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Error during encode avps", (Throwable)e);
        }
        return dba.getResult();
    }

    public byte[] encodeAvp(AvpImpl avp) {
        try {
            int payloadSize = avp.getRaw().length;
            boolean hasVendorId = avp.getVendorId() != 0L;
            int origLength = payloadSize + 8 + (hasVendorId ? 4 : 0);
            int tmp = payloadSize % 4;
            int paddingSize = tmp > 0 ? 4 - tmp : 0;
            byte[] bCode = this.int32ToBytes(avp.getCode());
            byte flags = (byte)((hasVendorId ? 128 : 0) | (avp.isMandatory() ? 64 : 0) | (avp.isEncrypted() ? 32 : 0));
            byte[] bFlags = this.int32ToBytes((flags << 24 & 0xFF000000) + origLength);
            byte[] bVendor = hasVendorId ? this.int32ToBytes((int)avp.getVendorId()) : new byte[]{};
            return this.concat(origLength + paddingSize, bCode, bFlags, bVendor, avp.getRaw());
        }
        catch (Exception e) {
            logger.debug("Error during encode avp", (Throwable)e);
            return new byte[0];
        }
    }

    private byte[] concat(int length, byte[] ... arrays) {
        if (length == 0) {
            for (byte[] array : arrays) {
                length += array.length;
            }
        }
        byte[] result = new byte[length];
        int pos = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, pos, array.length);
            pos += array.length;
        }
        return result;
    }

    protected ByteBuffer prepareBuffer(byte[] bytes, int len) throws AvpDataException {
        if (bytes.length != len) {
            throw new AvpDataException("Incorrect data length");
        }
        return ByteBuffer.wrap(bytes);
    }

    protected class DynamicByteArray {
        private byte[] array;
        private int size;

        public DynamicByteArray(int cap) {
            this.array = new byte[cap > 0 ? cap : 256];
            this.size = 0;
        }

        public int get(int pos) {
            if (pos >= this.size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.array[pos];
        }

        public void add(byte[] bytes) {
            if (this.size + bytes.length > this.array.length) {
                byte[] newarray = new byte[this.array.length + bytes.length * 2];
                System.arraycopy(this.array, 0, newarray, 0, this.size);
                this.array = newarray;
            }
            System.arraycopy(bytes, 0, this.array, this.size, bytes.length);
            this.size += bytes.length;
        }

        public byte[] getResult() {
            return Arrays.copyOfRange(this.array, 0, this.size);
        }
    }
}

