/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.parser;

import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownServiceException;
import java.util.Date;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.URI;
import org.jdiameter.client.impl.parser.ElementParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AvpImpl
implements Avp {
    private static final long serialVersionUID = 1L;
    private static final ElementParser parser = new ElementParser();
    int avpCode;
    long vendorID;
    boolean isMandatory = false;
    boolean isEncrypted = false;
    boolean isVendorSpecific = false;
    byte[] rawData = new byte[0];
    AvpSet groupedData;
    private static final Logger logger = LoggerFactory.getLogger(AvpImpl.class);
    private String toString;

    AvpImpl(int code, int flags, long vnd, byte[] data) {
        this.avpCode = code;
        this.isMandatory = (flags & 0x40) != 0;
        this.isEncrypted = (flags & 0x20) != 0;
        this.isVendorSpecific = (flags & 0x80) != 0;
        this.vendorID = vnd;
        this.rawData = data;
    }

    AvpImpl(Avp avp) {
        this.avpCode = avp.getCode();
        this.vendorID = avp.getVendorId();
        this.isMandatory = avp.isMandatory();
        this.isEncrypted = avp.isEncrypted();
        this.isVendorSpecific = avp.isVendorId();
        try {
            this.rawData = avp.getRaw();
            if (this.rawData == null || this.rawData.length == 0) {
                this.groupedData = avp.getGrouped();
            }
        }
        catch (AvpDataException e) {
            logger.debug("Can not create Avp", (Throwable)e);
        }
    }

    AvpImpl(int newCode, Avp avp) {
        this(avp);
        this.avpCode = newCode;
    }

    public int getCode() {
        return this.avpCode;
    }

    public boolean isVendorId() {
        return this.isVendorSpecific;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public long getVendorId() {
        return this.vendorID;
    }

    public byte[] getRaw() throws AvpDataException {
        return this.rawData;
    }

    public byte[] getOctetString() throws AvpDataException {
        return this.rawData;
    }

    public String getUTF8String() throws AvpDataException {
        try {
            return parser.bytesToUtf8String(this.rawData);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public int getInteger32() throws AvpDataException {
        try {
            return parser.bytesToInt(this.rawData);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public long getInteger64() throws AvpDataException {
        try {
            return parser.bytesToLong(this.rawData);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public long getUnsigned32() throws AvpDataException {
        try {
            byte[] u32ext = new byte[8];
            System.arraycopy(this.rawData, 0, u32ext, 4, 4);
            return parser.bytesToLong(u32ext);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public long getUnsigned64() throws AvpDataException {
        try {
            return parser.bytesToLong(this.rawData);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public float getFloat32() throws AvpDataException {
        try {
            return parser.bytesToFloat(this.rawData);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public double getFloat64() throws AvpDataException {
        try {
            return parser.bytesToDouble(this.rawData);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public InetAddress getAddress() throws AvpDataException {
        try {
            return parser.bytesToAddress(this.rawData);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public Date getTime() throws AvpDataException {
        try {
            return parser.bytesToDate(this.rawData);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public String getDiameterIdentity() throws AvpDataException {
        try {
            return parser.bytesToOctetString(this.rawData);
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public URI getDiameterURI() throws AvpDataException {
        try {
            return new URI(parser.bytesToOctetString(this.rawData));
        }
        catch (URISyntaxException e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
        catch (UnknownServiceException e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public AvpSet getGrouped() throws AvpDataException {
        try {
            if (this.groupedData == null) {
                this.groupedData = parser.decodeAvpSet(this.rawData);
                this.rawData = new byte[0];
            }
            return this.groupedData;
        }
        catch (Exception e) {
            throw new AvpDataException((Throwable)e, (Avp)this);
        }
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        return null;
    }

    public byte[] getRawData() {
        return this.rawData == null || this.rawData.length == 0 ? parser.encodeAvpSet(this.groupedData) : this.rawData;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = new StringBuffer("AvpImpl [avpCode=").append(this.avpCode).append(", vendorID=").append(this.vendorID).append("]@").append(super.hashCode()).toString();
        }
        return this.toString;
    }
}

