/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.helpers;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class UIDGenerator {
    private long value;
    private static final Lock mutex = new ReentrantLock();
    private static final ThreadLocal<Delta> ranges = new ThreadLocal<Delta>(){

        @Override
        protected synchronized Delta initialValue() {
            return new Delta();
        }
    };

    public UIDGenerator() {
        this.value = System.currentTimeMillis();
    }

    public UIDGenerator(long startValue) {
        this.value = startValue;
    }

    public int nextInt() {
        return (int)(Integer.MAX_VALUE & this.nextLong());
    }

    public long nextLong() {
        Delta d = ranges.get();
        if (d.start <= d.stop) {
            mutex.lock();
            this.value = d.update(this.value);
            mutex.unlock();
        }
        return d.start++;
    }

    private static class Delta {
        long start;
        long stop;

        private Delta() {
        }

        public long update(long value) {
            this.start = value;
            this.stop = value + 1L;
            return this.stop;
        }
    }
}

