/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.helpers;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.jdiameter.client.impl.helpers.Ordinal;

public class Loggers
extends Ordinal {
    private static final long serialVersionUID = 1L;
    protected static int index;
    private static ArrayList<Loggers> value;
    public static final Loggers Stack;
    public static final Loggers Peer;
    public static final Loggers PeerTable;
    public static final Loggers FSM;
    public static final Loggers Parser;
    public static final Loggers AVP;
    public static final Loggers Message;
    public static final Loggers Router;
    public static final Loggers Transport;
    private String description;
    private String fullName;

    public static Iterable<Loggers> values() {
        return value;
    }

    protected Loggers(String name, String fullName, String desc) {
        this.name = name;
        this.fullName = fullName == null ? "jDiameter" : "jDiameter." + fullName;
        this.description = desc;
        this.ordinal = index++;
        value.add(this);
    }

    public String fullName() {
        return this.fullName;
    }

    public String description() {
        return this.description;
    }

    public Logger logger() {
        return Logger.getLogger(this.fullName);
    }

    static {
        value = new ArrayList();
        Stack = new Loggers("Stack", null, "Logs the stack lifecycle");
        Peer = new Loggers("Peer", "peer", "Logs the peers");
        PeerTable = new Loggers("PeerTable", "peertable", "Logs the peer table subsystem");
        FSM = new Loggers("FSM", "peer.fsm", "Logs the peers fsm");
        Parser = new Loggers("Parser", "parser", "Logs the message parser");
        AVP = new Loggers("AVP", "parser.avp", "Logs the avp opetations processing");
        Message = new Loggers("Message", "parser.message", "Logs the message opetations/lifecycle processing");
        Router = new Loggers("Router", "router", "Logs the message router subsystem");
        Transport = new Loggers("Transport", "TCPTransport", "Logs the transport(tcp) opetations processing");
    }
}

