/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.helpers;

import org.jdiameter.api.Configuration;
import org.jdiameter.client.api.IAssembler;
import org.jdiameter.client.impl.helpers.ExtensionPoint;
import org.jdiameter.client.impl.helpers.Parameters;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoBuilder;

public class AssemblerImpl
implements IAssembler {
    AssemblerImpl parent;
    final AssemblerImpl[] childs = new AssemblerImpl[3];
    final MutablePicoContainer pico = new PicoBuilder().withCaching().build();

    public AssemblerImpl(Configuration config) throws Exception {
        Configuration[] ext;
        for (Configuration e : ext = config.getChildren(Parameters.Extensions.ordinal())) {
            String extName = e.getStringValue(Parameters.ExtensionName.ordinal(), "");
            if (extName.equals(ExtensionPoint.Internal.name())) {
                this.fill(ExtensionPoint.Internal.getExtensionPoints(), e, true);
                continue;
            }
            if (extName.equals(ExtensionPoint.StackLayer.name())) {
                this.updatePicoContainer(config, ExtensionPoint.StackLayer, ExtensionPoint.InternalMetaData, ExtensionPoint.InternalSessionFactory, ExtensionPoint.InternalMessageParser, ExtensionPoint.InternalElementParser);
                continue;
            }
            if (extName.equals(ExtensionPoint.ControllerLayer.name())) {
                this.updatePicoContainer(config, ExtensionPoint.ControllerLayer, ExtensionPoint.InternalPeerController, ExtensionPoint.InternalPeerFsmFactory, ExtensionPoint.InternalRouterEngine);
                continue;
            }
            if (!extName.equals(ExtensionPoint.TransportLayer.name())) continue;
            this.updatePicoContainer(config, ExtensionPoint.TransportLayer, ExtensionPoint.InternalTransportFactory);
        }
    }

    private void updatePicoContainer(Configuration config, ExtensionPoint pointType, ExtensionPoint ... updEntries) throws ClassNotFoundException {
        for (ExtensionPoint e : updEntries) {
            Configuration[] internalConf = config.getChildren(Parameters.Extensions.ordinal());
            String oldValue = internalConf[ExtensionPoint.Internal.id()].getStringValue(e.ordinal(), null);
            String newValue = internalConf[pointType.id()].getStringValue(e.ordinal(), null);
            if (oldValue == null || newValue == null) continue;
            this.pico.removeComponent(Class.forName(oldValue));
            this.pico.addComponent(Class.forName(newValue));
        }
    }

    protected AssemblerImpl(AssemblerImpl parent, Configuration e, ExtensionPoint p) throws Exception {
        this.parent = parent;
        this.fill(p.getExtensionPoints(), e, false);
    }

    private void fill(ExtensionPoint[] codes, Configuration e, boolean check) throws Exception {
        for (ExtensionPoint c : codes) {
            String value = e.getStringValue(c.ordinal(), c.defValue());
            if (!(check || value != null && value.trim().length() != 0)) {
                return;
            }
            try {
                this.pico.addComponent(Class.forName(value));
            }
            catch (NoClassDefFoundError exc) {
                throw new Exception(exc);
            }
        }
    }

    @Override
    public <T> T getComponentInstance(Class<T> aClass) {
        return (T)this.pico.getComponent(aClass);
    }

    @Override
    public void registerComponentInstance(Object object) {
        this.pico.addComponent(object);
    }

    public void registerComponentImplementation(Class aClass) {
        this.pico.addComponent((Object)aClass);
    }

    @Override
    public void registerComponentImplementation(Class<?> aClass, Object object) {
        this.pico.addComponent(object, aClass, new Parameter[0]);
    }

    public void unregister(Class aClass) {
        this.pico.removeComponent((Object)aClass);
    }

    @Override
    public void destroy() {
        this.pico.dispose();
    }

    @Override
    public IAssembler getParent() {
        return this.parent;
    }

    @Override
    public IAssembler[] getChilds() {
        return this.childs;
    }
}

