/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.rx;

import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.StateEvent;

public class Event
implements StateEvent {
    Type type;
    AppRequestEvent request;
    AppAnswerEvent answer;

    Event(Type type) {
        this.type = type;
    }

    Event(Type type, AppRequestEvent request, AppAnswerEvent answer) {
        this.type = type;
        this.answer = answer;
        this.request = request;
    }

    Event(boolean isRequest, AppRequestEvent request, AppAnswerEvent answer) throws AvpDataException {
        block15: {
            block14: {
                this.answer = answer;
                this.request = request;
                if (!isRequest) break block14;
                switch (request.getCommandCode()) {
                    case 265: {
                        this.type = Type.SEND_AAR;
                        break block15;
                    }
                    case 275: {
                        this.type = Type.SEND_STR;
                        break block15;
                    }
                    case 258: {
                        this.type = Type.RECEIVE_RAR;
                        break block15;
                    }
                    case 274: {
                        this.type = Type.RECEIVE_ASR;
                        break block15;
                    }
                    case 5: {
                        this.type = Type.SEND_EVENT_REQUEST;
                        break block15;
                    }
                    default: {
                        throw new RuntimeException("Wrong command code value: " + request.getCommandCode());
                    }
                }
            }
            switch (answer.getCommandCode()) {
                case 265: {
                    this.type = Type.RECEIVE_AAA;
                    break;
                }
                case 275: {
                    this.type = Type.RECEIVE_STA;
                    break;
                }
                case 258: {
                    this.type = Type.SEND_RAA;
                    break;
                }
                case 274: {
                    this.type = Type.SEND_ASA;
                }
                case 6: {
                    this.type = Type.RECEIVE_EVENT_ANSWER;
                    break;
                }
                default: {
                    throw new RuntimeException("Wrong CC-Request-Type value: " + answer.getCommandCode());
                }
            }
        }
    }

    public Enum getType() {
        return this.type;
    }

    public int compareTo(Object o) {
        return 0;
    }

    public Object getData() {
        return this.request != null ? this.request : this.answer;
    }

    public void setData(Object data) {
    }

    public AppEvent getRequest() {
        return this.request;
    }

    public AppEvent getAnswer() {
        return this.answer;
    }

    public <E> E encodeType(Class<E> eClass) {
        return (E)((Object)(eClass == Type.class ? this.type : null));
    }

    public static enum Type {
        SEND_AAR,
        RECEIVE_AAA,
        SEND_STR,
        RECEIVE_STA,
        SEND_RAA,
        RECEIVE_RAR,
        SEND_ASA,
        RECEIVE_ASR,
        SEND_EVENT_REQUEST,
        RECEIVE_EVENT_ANSWER;

    }
}

