/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.MetaData;
import org.jdiameter.api.Mode;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerState;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.validation.Dictionary;
import org.jdiameter.api.validation.ValidatorLevel;
import org.jdiameter.client.api.IAssembler;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.IMetaData;
import org.jdiameter.client.api.StackState;
import org.jdiameter.client.api.controller.IPeer;
import org.jdiameter.client.api.controller.IPeerTable;
import org.jdiameter.client.impl.AbstractStateChangeListener;
import org.jdiameter.client.impl.DictionarySingleton;
import org.jdiameter.client.impl.StackImplMBean;
import org.jdiameter.client.impl.VersionProperties;
import org.jdiameter.client.impl.helpers.ExtensionPoint;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.api.statistic.IStatisticProcessor;
import org.jdiameter.common.api.timer.ITimerFacility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackImpl
implements IContainer,
StackImplMBean {
    private static final Logger log = LoggerFactory.getLogger(StackImpl.class);
    protected IAssembler assembler;
    protected IConcurrentFactory concurrentFactory;
    protected Configuration config;
    protected IPeerTable peerManager;
    protected StackState state = StackState.IDLE;
    protected Lock lock = new ReentrantLock();
    protected ScheduledExecutorService scheduledFacility;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactory init(Configuration config) throws IllegalDiameterStateException, InternalException {
        this.lock.lock();
        if (log.isInfoEnabled()) {
            log.info("(-)(-)(-)(-)(-) Starting " + VersionProperties.instance.getProperty("vendor") + " DIAMETER Stack v" + VersionProperties.instance.getProperty("version") + " (-)(-)(-)(-)(-)");
        }
        try {
            if (this.state != StackState.IDLE) {
                throw new IllegalDiameterStateException();
            }
            try {
                Class<?> assemblerClass = Class.forName(config.getStringValue(Parameters.Assembler.ordinal(), (String)Parameters.Assembler.defValue()));
                this.assembler = (IAssembler)assemblerClass.getConstructor(Configuration.class).newInstance(config);
                this.assembler.registerComponentInstance(this);
                this.assembler.registerComponentInstance(config);
            }
            catch (Exception e) {
                throw new InternalException((Throwable)e);
            }
            this.config = config;
            this.concurrentFactory = this.assembler.getComponentInstance(IConcurrentFactory.class);
            try {
                Configuration[] dictionaryConfigs = config.getChildren(Parameters.Dictionary.ordinal());
                String dictionaryClassName = (String)Parameters.DictionaryClass.defValue();
                Boolean validatorEnabled = (Boolean)Parameters.DictionaryEnabled.defValue();
                ValidatorLevel validatorSendLevel = ValidatorLevel.fromString((String)((String)Parameters.DictionarySendLevel.defValue()));
                ValidatorLevel validatorReceiveLevel = ValidatorLevel.fromString((String)((String)Parameters.DictionaryReceiveLevel.defValue()));
                if (dictionaryConfigs != null && dictionaryConfigs.length > 0) {
                    Configuration dictionaryConfiguration = dictionaryConfigs[0];
                    dictionaryClassName = dictionaryConfiguration.getStringValue(Parameters.DictionaryClass.ordinal(), (String)Parameters.DictionaryClass.defValue());
                    validatorEnabled = dictionaryConfiguration.getBooleanValue(Parameters.DictionaryEnabled.ordinal(), ((Boolean)Parameters.DictionaryEnabled.defValue()).booleanValue());
                    validatorSendLevel = ValidatorLevel.fromString((String)dictionaryConfiguration.getStringValue(Parameters.DictionarySendLevel.ordinal(), (String)Parameters.DictionarySendLevel.defValue()));
                    validatorReceiveLevel = ValidatorLevel.fromString((String)dictionaryConfiguration.getStringValue(Parameters.DictionaryReceiveLevel.ordinal(), (String)Parameters.DictionaryReceiveLevel.defValue()));
                }
                this.createDictionary(dictionaryClassName, validatorEnabled, validatorSendLevel, validatorReceiveLevel);
            }
            catch (Exception e) {
                throw new InternalException((Throwable)e);
            }
            this.peerManager = this.assembler.getComponentInstance(IPeerTable.class);
            this.peerManager.setAssembler(this.assembler);
            this.state = StackState.CONFIGURED;
        }
        finally {
            this.lock.unlock();
        }
        if (log.isInfoEnabled()) {
            log.info("(-)(-)(-)(-)(-) Started  " + VersionProperties.instance.getProperty("vendor") + " DIAMETER Stack v" + VersionProperties.instance.getProperty("version") + " (-)(-)(-)(-)(-)");
        }
        return this.assembler.getComponentInstance(SessionFactory.class);
    }

    private void createDictionary(String clazz, boolean validatorEnabled, ValidatorLevel validatorSendLevel, ValidatorLevel validatorReceiveLevel) throws InternalException {
        DictionarySingleton.init(clazz, validatorEnabled, validatorSendLevel, validatorReceiveLevel);
    }

    public SessionFactory getSessionFactory() throws IllegalDiameterStateException {
        if (this.state == StackState.CONFIGURED || this.state == StackState.STARTED) {
            return this.assembler.getComponentInstance(SessionFactory.class);
        }
        throw new IllegalDiameterStateException();
    }

    public Dictionary getDictionary() throws IllegalDiameterStateException {
        return DictionarySingleton.getDictionary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IllegalDiameterStateException, InternalException {
        this.lock.lock();
        try {
            if (this.state != StackState.STOPPED && this.state != StackState.CONFIGURED) {
                throw new IllegalDiameterStateException();
            }
            this.scheduledFacility = this.concurrentFactory.getScheduledExecutorService(IConcurrentFactory.ScheduledExecServices.ProcessingMessageTimer.name());
            this.assembler.getComponentInstance(ISessionDatasource.class).start();
            this.assembler.getComponentInstance(IStatisticProcessor.class).start();
            this.assembler.getComponentInstance(ITimerFacility.class);
            this.startPeerManager();
            this.state = StackState.STARTED;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Mode mode, long timeOut, TimeUnit timeUnit) throws IllegalDiameterStateException, InternalException {
        this.lock.lock();
        try {
            if (this.state != StackState.STOPPED && this.state != StackState.CONFIGURED) {
                throw new IllegalDiameterStateException();
            }
            this.scheduledFacility = this.concurrentFactory.getScheduledExecutorService(IConcurrentFactory.ScheduledExecServices.ProcessingMessageTimer.name());
            this.assembler.getComponentInstance(IStatisticProcessor.class).start();
            this.assembler.getComponentInstance(ISessionDatasource.class).start();
            this.assembler.getComponentInstance(ITimerFacility.class);
            List peerTable = this.peerManager.getPeerTable();
            final CountDownLatch barrier = new CountDownLatch(Mode.ANY_PEER.equals((Object)mode) ? Math.min(peerTable.size(), 1) : peerTable.size());
            AbstractStateChangeListener listener = new AbstractStateChangeListener(){

                @Override
                public void stateChanged(Enum oldState, Enum newState) {
                    if (PeerState.OKAY.equals((Object)newState)) {
                        barrier.countDown();
                    }
                }
            };
            for (Peer p : peerTable) {
                ((IPeer)p).addStateChangeListener(listener);
            }
            this.startPeerManager();
            try {
                barrier.await(timeOut, timeUnit);
                if (barrier.getCount() != 0L) {
                    throw new InternalException("TimeOut");
                }
                this.state = StackState.STARTED;
            }
            catch (InterruptedException e) {
                throw new InternalException("TimeOut");
            }
            finally {
                for (Peer p : peerTable) {
                    ((IPeer)p).remStateChangeListener(listener);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startPeerManager() throws InternalException {
        try {
            if (this.peerManager != null) {
                this.peerManager.start();
            }
            ((IMetaData)this.getMetaData().unwrap(IMetaData.class)).updateLocalHostStateId();
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long timeOut, TimeUnit timeUnit, int disconnectCause) throws IllegalDiameterStateException, InternalException {
        block21: {
            this.lock.lock();
            try {
                if (this.state != StackState.STARTED && this.state != StackState.CONFIGURED) break block21;
                if (log.isInfoEnabled()) {
                    log.info("(-)(-)(-)(-)(-) Stopping " + VersionProperties.instance.getProperty("vendor") + " DIAMETER Stack v" + VersionProperties.instance.getProperty("version") + " (-)(-)(-)(-)(-)");
                }
                List peerTable = this.peerManager.getPeerTable();
                final CountDownLatch barrier = new CountDownLatch(peerTable.size());
                AbstractStateChangeListener listener = new AbstractStateChangeListener(){

                    @Override
                    public void stateChanged(Enum oldState, Enum newState) {
                        if (PeerState.DOWN.equals((Object)newState)) {
                            barrier.countDown();
                        }
                    }
                };
                for (Peer p : peerTable) {
                    if (((PeerState)p.getState(PeerState.class)).equals((Object)PeerState.DOWN)) {
                        barrier.countDown();
                        continue;
                    }
                    ((IPeer)p).addStateChangeListener(listener);
                }
                if (this.peerManager != null) {
                    try {
                        this.peerManager.stopping(disconnectCause);
                    }
                    catch (Exception e) {
                        log.warn("Stopping error", (Throwable)e);
                    }
                }
                try {
                    barrier.await(timeOut, timeUnit);
                    if (barrier.getCount() != 0L) {
                        throw new InternalException("TimeOut");
                    }
                }
                catch (InterruptedException e) {
                    throw new InternalException("TimeOut");
                }
                finally {
                    this.state = StackState.STOPPED;
                    for (Peer p : peerTable) {
                        ((IPeer)p).remStateChangeListener(listener);
                    }
                }
                this.assembler.getComponentInstance(ISessionDatasource.class).stop();
                this.assembler.getComponentInstance(IStatisticProcessor.class).stop();
                try {
                    if (this.peerManager != null) {
                        this.peerManager.stopped();
                    }
                    if (this.scheduledFacility != null) {
                        this.concurrentFactory.shutdownNow(this.scheduledFacility);
                    }
                }
                catch (Exception e) {
                    log.warn("Stopped error", (Throwable)e);
                }
                this.state = StackState.STOPPED;
                if (log.isInfoEnabled()) {
                    log.info("(-)(-)(-)(-)(-) Stopped  " + VersionProperties.instance.getProperty("vendor") + " DIAMETER Stack v" + VersionProperties.instance.getProperty("version") + " (-)(-)(-)(-)(-)");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.state == StackState.STARTED) {
            log.warn("Calling destroy() with Stack in STARTED state. Calling stop(REBOOTING) before, please do it yourself with the proper cause.");
            this.stop(0);
        }
        this.lock.lock();
        try {
            if (this.peerManager != null) {
                this.peerManager.destroy();
            }
            if (this.assembler != null) {
                this.assembler.destroy();
            }
            if (this.scheduledFacility != null) {
                this.concurrentFactory.shutdownNow(this.scheduledFacility);
            }
        }
        catch (Exception e) {
            log.warn("Destroy error", (Throwable)e);
        }
        finally {
            this.state = StackState.IDLE;
            this.lock.unlock();
        }
    }

    @Override
    public boolean isActive() {
        return this.state == StackState.STARTED;
    }

    public java.util.logging.Logger getLogger() {
        return java.util.logging.Logger.getAnonymousLogger();
    }

    public MetaData getMetaData() {
        if (this.state == StackState.IDLE) {
            throw new IllegalStateException("Meta data not defined");
        }
        return this.assembler.getComponentInstance(IMetaData.class);
    }

    public <T extends BaseSession> T getSession(String sessionId, Class<T> clazz) throws InternalException {
        if (this.getState() == StackState.IDLE) {
            throw new InternalException("Illegal state of stack");
        }
        BaseSession bs = this.assembler.getComponentInstance(ISessionDatasource.class).getSession(sessionId);
        return (T)(bs != null ? bs : null);
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        boolean isWrap;
        boolean bl = isWrap = aClass == PeerTable.class;
        if (!isWrap) {
            boolean bl2 = isWrap = this.assembler.getChilds()[ExtensionPoint.StackLayer.id()].getComponentInstance(aClass) != null;
        }
        if (!isWrap) {
            boolean bl3 = isWrap = this.assembler.getChilds()[ExtensionPoint.ControllerLayer.id()].getComponentInstance(aClass) != null;
        }
        if (!isWrap) {
            isWrap = this.assembler.getChilds()[ExtensionPoint.TransportLayer.id()].getComponentInstance(aClass) != null;
        }
        return isWrap;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        T unwrapObject = null;
        if (aClass == PeerTable.class) {
            unwrapObject = this.assembler.getComponentInstance(aClass);
        }
        if (unwrapObject == null) {
            unwrapObject = this.assembler.getChilds()[ExtensionPoint.StackLayer.id()].getComponentInstance(aClass);
        }
        if (unwrapObject == null) {
            unwrapObject = this.assembler.getChilds()[ExtensionPoint.ControllerLayer.id()].getComponentInstance(aClass);
        }
        if (unwrapObject == null) {
            unwrapObject = this.assembler.getChilds()[ExtensionPoint.TransportLayer.id()].getComponentInstance(aClass);
        }
        return unwrapObject;
    }

    @Override
    public StackState getState() {
        return this.state;
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public IAssembler getAssemblerFacility() {
        return this.assembler;
    }

    @Override
    public void sendMessage(IMessage message) throws RouteException, AvpDataException, IllegalDiameterStateException, IOException {
        this.peerManager.sendMessage(message);
    }

    @Override
    public void addSessionListener(String sessionId, NetworkReqListener listener) {
        this.peerManager.addSessionReqListener(sessionId, listener);
    }

    @Override
    public void removeSessionListener(String sessionId) {
        this.peerManager.removeSessionListener(sessionId);
    }

    @Override
    public ScheduledExecutorService getScheduledFacility() {
        return this.scheduledFacility;
    }

    @Override
    public IConcurrentFactory getConcurrentFactory() {
        return this.concurrentFactory;
    }

    @Override
    public String configuration() {
        return this.config != null ? this.config.toString() : "not set";
    }

    @Override
    public String metaData() {
        try {
            return this.getMetaData().toString();
        }
        catch (Exception exc) {
            return "not set";
        }
    }

    @Override
    public String peerDescription(String name) {
        try {
            for (Peer p : this.unwrap(PeerTable.class).getPeerTable()) {
                if (!p.getUri().getFQDN().equals(name)) continue;
                return p.toString();
            }
        }
        catch (InternalException e) {
            log.debug("InternalException", (Throwable)e);
        }
        return "not set";
    }

    @Override
    public String peerList() {
        try {
            return this.unwrap(PeerTable.class).getPeerTable().toString();
        }
        catch (InternalException e) {
            return "not set";
        }
    }

    @Override
    public void stop(int disconnectCause) {
        try {
            this.stop(10L, TimeUnit.SECONDS, disconnectCause);
        }
        catch (Exception e) {
            log.debug("Exception", (Throwable)e);
        }
    }
}

