/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl;

import java.util.concurrent.TimeUnit;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.RawSession;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.Session;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.BaseSessionImpl;
import org.jdiameter.client.impl.MessageUtility;
import org.jdiameter.client.impl.SessionImpl;

public class RawSessionImpl
extends BaseSessionImpl
implements RawSession {
    RawSessionImpl(IContainer stack) {
        this.container = stack;
        this.parser = this.container.getAssemblerFacility().getComponentInstance(IMessageParser.class);
    }

    public Message createMessage(int commandCode, ApplicationId appId, Avp ... avps) {
        if (this.isValid) {
            this.lastAccessedTime = System.currentTimeMillis();
            IMessage m = this.parser.createEmptyMessage(commandCode, this.getAppId(appId));
            m.getAvps().addAvp(avps);
            this.appendAppId(appId, (Message)m);
            return m;
        }
        throw new IllegalStateException("Session already released");
    }

    public Message createMessage(int commandCode, ApplicationId appId, long hopByHopIdentifier, long endToEndIdentifier, Avp ... avps) {
        if (this.isValid) {
            this.lastAccessedTime = System.currentTimeMillis();
            IMessage m = this.parser.createEmptyMessage(commandCode, this.getAppId(appId));
            if (hopByHopIdentifier >= 0L) {
                m.setHopByHopIdentifier(-hopByHopIdentifier);
            }
            if (endToEndIdentifier >= 0L) {
                m.setEndToEndIdentifier(endToEndIdentifier);
            }
            m.getAvps().addAvp(avps);
            this.appendAppId(appId, (Message)m);
            return m;
        }
        throw new IllegalStateException("Session already released");
    }

    public Message createMessage(Message message, boolean copyAvps) {
        if (this.isValid) {
            this.lastAccessedTime = System.currentTimeMillis();
            IMessage newMessage = null;
            IMessage inner = (IMessage)message;
            if (copyAvps) {
                newMessage = this.parser.createEmptyMessage(inner);
                MessageUtility.addOriginAvps((Message)newMessage, this.container.getMetaData());
            } else {
                newMessage = (IMessage)this.createMessage(inner.getCommandCode(), inner.getSingleApplicationId(), -1L, -1L, new Avp[0]);
            }
            newMessage.setRequest(message.isRequest());
            newMessage.setProxiable(message.isProxiable());
            newMessage.setError(message.isError());
            newMessage.setReTransmitted(message.isReTransmitted());
            return newMessage;
        }
        throw new IllegalStateException("Session already released");
    }

    public void send(Message message, EventListener<Message, Message> listener) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.genericSend(message, listener);
    }

    public void send(Message message, EventListener<Message, Message> listener, long timeOut, TimeUnit timeUnit) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.genericSend(message, listener, timeOut, timeUnit);
    }

    public void release() {
        this.isValid = false;
        this.container = null;
        this.parser = null;
    }

    public boolean isWrapperFor(Class<?> iface) throws InternalException {
        return iface == Session.class;
    }

    public <T> T unwrap(Class<T> iface) throws InternalException {
        return (T)(iface == Session.class ? new SessionImpl(this.container) : null);
    }
}

