/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IEventListener;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.MessageUtility;
import org.jdiameter.client.impl.MyEventListener;
import org.jdiameter.client.impl.helpers.Parameters;

public abstract class BaseSessionImpl
implements BaseSession {
    protected final long creationTime;
    protected long lastAccessedTime;
    protected boolean isValid;
    protected String sessionId;
    protected transient IContainer container;
    protected transient IMessageParser parser;
    protected NetworkReqListener reqListener;

    public BaseSessionImpl() {
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.isValid = true;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isAppSession() {
        return false;
    }

    public boolean isReplicable() {
        return false;
    }

    protected void genericSend(Message message, EventListener listener) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        if (!this.isValid) {
            throw new IllegalDiameterStateException("Session already released");
        }
        long timeOut = this.container.getConfiguration().getLongValue(Parameters.MessageTimeOut.ordinal(), ((Long)Parameters.MessageTimeOut.defValue()).longValue());
        this.genericSend(message, listener, timeOut, TimeUnit.MILLISECONDS);
    }

    protected void genericSend(Message aMessage, EventListener listener, long timeout, TimeUnit timeUnit) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        if (this.isValid) {
            this.lastAccessedTime = System.currentTimeMillis();
            IMessage message = (IMessage)aMessage;
            IEventListener localListener = this.createListenerWrapper(listener);
            if (message.isRequest()) {
                message.setListener(localListener);
                if (message.getAvps().getAvpByIndex(0).getCode() != 263 && this.sessionId != null) {
                    message.getAvps().removeAvp(263);
                    message.getAvps().insertAvp(0, 263, this.sessionId, true, false, false);
                }
            }
            MessageUtility.addOriginAvps(aMessage, this.container.getMetaData());
            if (message.getState() != 0 && message.getState() != 3) {
                throw new IllegalDiameterStateException("Illegal state");
            }
            message.createTimer(this.container.getScheduledFacility(), timeout, timeUnit);
            try {
                this.container.sendMessage(message);
            }
            catch (RouteException e) {
                message.clearTimer();
                throw e;
            }
            catch (Exception e) {
                message.clearTimer();
                throw new InternalException((Throwable)e);
            }
        } else {
            throw new IllegalDiameterStateException("Session already released");
        }
    }

    protected IEventListener createListenerWrapper(EventListener listener) {
        return listener == null ? null : new MyEventListener(this, listener);
    }

    public Future<Message> send(Message message) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        MyFuture future = new MyFuture();
        future.send(message);
        return future;
    }

    public Future<Message> send(Message message, long timeOut, TimeUnit timeUnit) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        MyFuture future = new MyFuture();
        future.send(message, timeOut, timeUnit);
        return future;
    }

    protected void appendAppId(ApplicationId appId, Message m) {
        if (appId == null) {
            return;
        }
        for (Avp avp : m.getAvps()) {
            int code = avp.getCode();
            if (code != 259 && code != 258 && code != 260) continue;
            return;
        }
        if (appId.getVendorId() == 0L) {
            if (appId.getAcctAppId() != 0L) {
                m.getAvps().addAvp(259, appId.getAcctAppId(), true, false, true);
            }
            if (appId.getAuthAppId() != 0L) {
                m.getAvps().addAvp(258, appId.getAuthAppId(), true, false, true);
            }
        } else {
            AvpSet avp = m.getAvps().addGroupedAvp(260, true, false);
            avp.addAvp(266, appId.getVendorId(), true, false, true);
            if (appId.getAuthAppId() != 0L) {
                avp.addAvp(258, appId.getAuthAppId(), true, false, true);
            }
            if (appId.getAcctAppId() != 0L) {
                avp.addAvp(259, appId.getAcctAppId(), true, false, true);
            }
        }
    }

    protected long getAppId(ApplicationId appId) {
        if (appId == null) {
            return 0L;
        }
        if (appId.getAcctAppId() != 0L) {
            return appId.getAcctAppId();
        }
        if (appId.getAuthAppId() != 0L) {
            return appId.getAuthAppId();
        }
        return appId.getVendorId();
    }

    private class MyFuture
    implements Future<Message> {
        private boolean canceled;
        private boolean done;
        private boolean timeOut;
        private Lock lock = new ReentrantLock();
        private CountDownLatch block = new CountDownLatch(1);
        private Message result;

        private MyFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.lock.lock();
            try {
                this.canceled = true;
                this.done = false;
                this.block.countDown();
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.canceled;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Message get() throws InterruptedException, ExecutionException {
            try {
                this.block.await();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
            Message rc = this.canceled ? null : this.result;
            this.result = null;
            return rc;
        }

        @Override
        public Message get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                this.block.await(timeout, unit);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
            if (this.timeOut) {
                throw new TimeoutException();
            }
            Message rc = this.canceled ? null : this.result;
            this.result = null;
            return rc;
        }

        private IEventListener createListener() {
            return new IEventListener(){

                @Override
                public void setValid(boolean value) {
                }

                @Override
                public boolean isValid() {
                    return !MyFuture.this.canceled;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void receivedSuccessMessage(Request r, Answer a) {
                    MyFuture.this.lock.lock();
                    try {
                        if (!MyFuture.this.canceled) {
                            MyFuture.this.result = (Message)a;
                            MyFuture.this.canceled = false;
                            MyFuture.this.done = true;
                        }
                        MyFuture.this.block.countDown();
                    }
                    finally {
                        MyFuture.this.lock.unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void timeoutExpired(Request message) {
                    MyFuture.this.lock.lock();
                    try {
                        if (!MyFuture.this.canceled) {
                            MyFuture.this.done = true;
                            MyFuture.this.timeOut = true;
                        }
                        MyFuture.this.block.countDown();
                    }
                    finally {
                        MyFuture.this.lock.unlock();
                    }
                }
            };
        }

        public void send(Message message) throws RouteException, OverloadException, IllegalDiameterStateException, InternalException {
            BaseSessionImpl.this.genericSend(message, this.createListener());
        }

        public void send(Message message, long timeOut, TimeUnit timeUnit) throws RouteException, OverloadException, IllegalDiameterStateException, InternalException {
            BaseSessionImpl.this.genericSend(message, this.createListener(), timeOut, timeUnit);
        }
    }
}

