/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.api;

import java.io.Serializable;

public final class ApplicationId
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long UNDEFINED_VALUE = 0L;
    private long venId = 0L;
    private long authId = 0L;
    private long acctId = 0L;

    public static ApplicationId createByAuthAppId(long authAppId) {
        return new ApplicationId(0L, authAppId, 0L);
    }

    public static ApplicationId createByAccAppId(long acchAppId) {
        return new ApplicationId(0L, 0L, acchAppId);
    }

    public static ApplicationId createByAuthAppId(long vendorId, long authAppId) {
        return new ApplicationId(vendorId, authAppId, 0L);
    }

    public static ApplicationId createByAccAppId(long vendorId, long acchAppId) {
        return new ApplicationId(vendorId, 0L, acchAppId);
    }

    private ApplicationId(long vendorId, long authAppId, long acctAppId) {
        this.authId = authAppId;
        this.acctId = acctAppId;
        this.venId = vendorId;
    }

    public long getVendorId() {
        return this.venId;
    }

    public long getAuthAppId() {
        return this.authId;
    }

    public long getAcctAppId() {
        return this.acctId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ApplicationId) {
            ApplicationId appId = (ApplicationId)obj;
            return this.authId == appId.authId && this.acctId == appId.acctId && this.venId == appId.venId;
        }
        return false;
    }

    public int hashCode() {
        int result = (int)(this.venId ^ this.venId >>> 32);
        result = 31 * result + (int)(this.authId ^ this.authId >>> 32);
        result = 31 * result + (int)(this.acctId ^ this.acctId >>> 32);
        return result;
    }

    public String toString() {
        return new StringBuffer("AppId [").append("Vendor-Id:").append(this.venId).append("; Auth-Application-Id:").append(this.authId).append("; Acct-Application-Id:").append(this.acctId).append("]").toString();
    }

    public static interface Ranges {
        public static final long STANDARDS_TRACK_APPLICATIONS_MIN = 1L;
        public static final long STANDARDS_TRACK_APPLICATIONS_MAX = 0xFFFFFFL;
        public static final long VENDOR_SPECIFIC_APPLICATIONS_MIN = 0x1000000L;
        public static final long VENDOR_SPECIFIC_APPLICATIONS_MAX = -2L;
    }

    public static interface Standard {
        public static final long DIAMETER_COMMON_MESSAGE = 0L;
        public static final long NASREQ = 1L;
        public static final long MOBILE_IP = 2L;
        public static final long DIAMETER_BASE_ACCOUNTING = 3L;
        public static final long RELAY = -1L;
    }
}

