/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.List;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.HeadEqBody;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.mXparser;

public class Constant
extends PrimitiveElement {
    public static final int NOT_FOUND = -1;
    public static final int TYPE_ID = 104;
    public static final String TYPE_DESC = "User defined constant";
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    private static final String NO_SYNTAX_ERROR_MSG = "Constant - no syntax errors.";
    private String constantName;
    private double constantValue;
    private String description;
    private List<Expression> relatedExpressionsList;
    private boolean syntaxStatus;
    private String errorMessage;

    public Constant(String constantName, double constantValue) {
        super(104);
        this.relatedExpressionsList = new ArrayList<Expression>();
        if (mXparser.regexMatch(constantName, "(([a-zA-Z_])+([a-zA-Z0-9_])*|\\[([a-zA-Z_])+([a-zA-Z0-9_])*\\])")) {
            this.constantName = constantName;
            this.constantValue = constantValue;
            this.description = "";
            this.syntaxStatus = true;
            this.errorMessage = NO_SYNTAX_ERROR_MSG;
        } else {
            this.syntaxStatus = false;
            this.errorMessage = "[" + constantName + "] --> invalid constant name, pattern not mathes: " + "(([a-zA-Z_])+([a-zA-Z0-9_])*|\\[([a-zA-Z_])+([a-zA-Z0-9_])*\\])";
        }
    }

    public Constant(String constantName, double constantValue, String description) {
        super(104);
        this.relatedExpressionsList = new ArrayList<Expression>();
        if (mXparser.regexMatch(constantName, "(([a-zA-Z_])+([a-zA-Z0-9_])*|\\[([a-zA-Z_])+([a-zA-Z0-9_])*\\])")) {
            this.constantName = constantName;
            this.constantValue = constantValue;
            this.description = description;
            this.syntaxStatus = true;
            this.errorMessage = NO_SYNTAX_ERROR_MSG;
        } else {
            this.syntaxStatus = false;
            this.errorMessage = "[" + constantName + "] --> invalid constant name, pattern not mathes: " + "(([a-zA-Z_])+([a-zA-Z0-9_])*|\\[([a-zA-Z_])+([a-zA-Z0-9_])*\\])";
        }
    }

    public Constant(String constantDefinitionString, PrimitiveElement ... elements) {
        super(104);
        this.description = "";
        this.syntaxStatus = false;
        this.relatedExpressionsList = new ArrayList<Expression>();
        if (mXparser.regexMatch(constantDefinitionString, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|\\[([a-zA-Z_])+([a-zA-Z0-9_])*\\])(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(constantDefinitionString);
            this.constantName = headEqBody.headTokens.get((int)0).tokenStr;
            Expression bodyExpression = new Expression(headEqBody.bodyStr, elements);
            this.constantValue = bodyExpression.calculate();
            this.syntaxStatus = bodyExpression.getSyntaxStatus();
            this.errorMessage = bodyExpression.getErrorMessage();
        } else {
            this.errorMessage = "[" + constantDefinitionString + "] --> pattern not mathes: " + "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|\\[([a-zA-Z_])+([a-zA-Z0-9_])*\\])(\\s)*=(\\s)*(.)+(\\s)*";
        }
    }

    public String getConstantName() {
        return this.constantName;
    }

    public void setConstantName(String constantName) {
        if (mXparser.regexMatch(constantName, "(([a-zA-Z_])+([a-zA-Z0-9_])*|\\[([a-zA-Z_])+([a-zA-Z0-9_])*\\])")) {
            this.constantName = constantName;
            this.setExpressionModifiedFlags();
        } else {
            this.syntaxStatus = false;
            this.errorMessage = "[" + constantName + "] --> invalid constant name, pattern not mathes: " + "(([a-zA-Z_])+([a-zA-Z0-9_])*|\\[([a-zA-Z_])+([a-zA-Z0-9_])*\\])";
        }
    }

    public void setConstantValue(double constantValue) {
        this.constantValue = constantValue;
    }

    public double getConstantValue() {
        return this.constantValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getSyntaxStatus() {
        return this.syntaxStatus;
    }

    void addRelatedExpression(Expression expression) {
        if (expression != null && !this.relatedExpressionsList.contains(expression)) {
            this.relatedExpressionsList.add(expression);
        }
    }

    void removeRelatedExpression(Expression expression) {
        if (expression != null) {
            this.relatedExpressionsList.remove(expression);
        }
    }

    void setExpressionModifiedFlags() {
        for (Expression e : this.relatedExpressionsList) {
            e.setExpressionModifiedFlag();
        }
    }
}

