/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLResultSet;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.query.MySQLQuery;
import org.mariadb.jdbc.internal.common.query.Query;
import org.mariadb.jdbc.internal.common.queryresults.ModifyQueryResult;
import org.mariadb.jdbc.internal.common.queryresults.QueryResult;
import org.mariadb.jdbc.internal.common.queryresults.ResultSetType;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;

public class MySQLStatement
implements Statement {
    private final MySQLProtocol protocol;
    protected MySQLConnection connection;
    private QueryResult queryResult;
    private boolean warningsCleared;
    private int queryTimeout;
    private boolean escapeProcessing;
    private int fetchSize;
    private int maxRows;
    boolean isClosed;
    private static volatile Timer timer;
    private TimerTask timerTask;
    boolean isTimedout;
    volatile boolean executing;
    List<Query> batchQueries;
    Queue<Object> cachedResultSets;
    protected boolean isRewriteable = true;
    protected String firstRewrite = null;
    protected ResultSet batchResultSet = null;

    public boolean isStreaming() {
        return this.fetchSize == Integer.MIN_VALUE;
    }

    public MySQLStatement(MySQLConnection connection) {
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.escapeProcessing = true;
        this.cachedResultSets = new LinkedList<Object>();
    }

    public MySQLProtocol getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Timer getTimer() {
        Timer result = timer;
        if (result != null) return result;
        Class<MySQLStatement> clazz = MySQLStatement.class;
        synchronized (MySQLStatement.class) {
            result = timer;
            if (result != null) return result;
            timer = result = new Timer("MariaDB-JDBC-Timer", true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private void setTimerTask() {
        assert (this.timerTask == null);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    MySQLStatement.this.isTimedout = true;
                    MySQLStatement.this.protocol.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        MySQLStatement.getTimer().schedule(this.timerTask, this.queryTimeout * 1000);
    }

    private void checkReconnect() throws SQLException {
        if (this.protocol.shouldReconnect()) {
            try {
                this.protocol.connect();
            }
            catch (QueryException qe) {
                SQLExceptionMapper.throwException(qe, this.connection, this);
            }
        } else if (this.protocol.shouldTryFailback()) {
            try {
                this.protocol.reconnectToMaster();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void executeQueryProlog() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("execute() is called on closed statement");
        }
        this.checkReconnect();
        if (this.protocol.isClosed()) {
            throw new SQLException("execute() is called on closed connection");
        }
        if (this.protocol.hasUnreadData()) {
            throw new SQLException("There is an open result set on the current connection, which must be closed prior to executing a query");
        }
        if (this.protocol.hasMoreResults()) {
            while (this.getMoreResults(true)) {
            }
        }
        this.cachedResultSets.clear();
        MySQLConnection conn = (MySQLConnection)this.getConnection();
        conn.reenableWarnings();
        try {
            this.protocol.setMaxRows(this.maxRows);
        }
        catch (QueryException qe) {
            SQLExceptionMapper.throwException(qe, this.connection, this);
        }
        if (this.queryTimeout != 0) {
            this.setTimerTask();
        }
    }

    private void cacheMoreResults() {
        if (this.isStreaming()) {
            return;
        }
        QueryResult saveResult = this.queryResult;
        try {
            while (this.protocol.hasMoreResults()) {
                this.getMoreResults(false);
                this.cachedResultSets.add(this.queryResult);
            }
        }
        catch (SQLException e) {
            this.cachedResultSets.add(e);
        }
        this.queryResult = saveResult;
    }

    private void executeQueryEpilog(QueryException e, Query query) throws SQLException {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.isTimedout) {
            this.isTimedout = false;
            e = new QueryException("Query timed out", 1317, "JZ0002", e);
        }
        if (e == null) {
            return;
        }
        if (this.protocol.getInfo().getProperty("dumpQueriesOnException", "false").equalsIgnoreCase("true") || e.getErrorCode() == 1064) {
            String queryString = query.toString();
            if (queryString.length() > 4096) {
                queryString = queryString.substring(0, 4096);
            }
            e.setMessage(e.getMessage() + "\nQuery is:\n" + queryString);
        }
        SQLExceptionMapper.throwException(e, this.connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(Query query) throws SQLException {
        MySQLProtocol mySQLProtocol = this.protocol;
        synchronized (mySQLProtocol) {
            boolean bl;
            if (this.protocol.activeResult != null) {
                this.protocol.activeResult.close();
            }
            this.executing = true;
            QueryException exception = null;
            this.executeQueryProlog();
            try {
                this.batchResultSet = null;
                this.queryResult = this.protocol.executeQuery(query, this.isStreaming());
                this.cacheMoreResults();
                bl = this.queryResult.getResultSetType() == ResultSetType.SELECT;
            }
            catch (QueryException e) {
                boolean bl2;
                try {
                    exception = e;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    this.executeQueryEpilog(exception, query);
                    this.executing = false;
                    throw throwable;
                }
                this.executeQueryEpilog(exception, query);
                this.executing = false;
                return bl2;
            }
            this.executeQueryEpilog(exception, query);
            this.executing = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(List<Query> queries, boolean isRewritable, int rewriteOffset) throws SQLException {
        MySQLProtocol mySQLProtocol = this.protocol;
        synchronized (mySQLProtocol) {
            boolean bl;
            if (this.protocol.activeResult != null) {
                this.protocol.activeResult.close();
            }
            this.executing = true;
            QueryException exception = null;
            this.executeQueryProlog();
            try {
                this.batchResultSet = null;
                this.queryResult = this.protocol.executeQuery(queries, this.isStreaming(), isRewritable, rewriteOffset);
                this.cacheMoreResults();
                bl = this.queryResult.getResultSetType() == ResultSetType.SELECT;
            }
            catch (QueryException e) {
                boolean bl2;
                try {
                    exception = e;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    this.executeQueryEpilog(exception, queries.get(0));
                    this.executing = false;
                    throw throwable;
                }
                this.executeQueryEpilog(exception, queries.get(0));
                this.executing = false;
                return bl2;
            }
            this.executeQueryEpilog(exception, queries.get(0));
            this.executing = false;
            return bl;
        }
    }

    protected ResultSet executeQuery(Query query) throws SQLException {
        if (this.execute(query)) {
            return this.getResultSet();
        }
        return MySQLResultSet.EMPTY;
    }

    protected int executeUpdate(Query query) throws SQLException {
        if (this.execute(query)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    private Query stringToQuery(String queryString) throws SQLException {
        if (this.escapeProcessing) {
            queryString = Utils.nativeSQL(queryString, this.connection.noBackslashEscapes);
        }
        return new MySQLQuery(queryString);
    }

    @Override
    public boolean execute(String queryString) throws SQLException {
        return this.execute(this.stringToQuery(queryString));
    }

    @Override
    public int executeUpdate(String queryString) throws SQLException {
        return this.executeUpdate(this.stringToQuery(queryString));
    }

    @Override
    public ResultSet executeQuery(String queryString) throws SQLException {
        return this.executeQuery(this.stringToQuery(queryString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.queryResult != null) {
            this.queryResult.close();
            this.queryResult = null;
        }
        this.cachedResultSets.clear();
        if (this.isStreaming()) {
            MySQLProtocol mySQLProtocol = this.protocol;
            synchronized (mySQLProtocol) {
                while (this.getMoreResults(true)) {
                }
            }
        }
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max rows is negative");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    public void setLocalInfileInputStream(InputStream inputStream) {
        this.protocol.setLocalInfileInputStream(inputStream);
    }

    @Override
    public void cancel() throws SQLException {
        try {
            if (!this.executing) {
                return;
            }
            this.protocol.cancelCurrentQuery();
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, this.connection, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (!this.warningsCleared) {
            return this.connection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Cursors are not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.batchResultSet != null) {
            return this.batchResultSet;
        }
        if (this.queryResult != null && this.queryResult.getResultSetType() == ResultSetType.MODIFY) {
            long insertId = ((ModifyQueryResult)this.queryResult).getInsertId();
            if (insertId == 0L) {
                return MySQLResultSet.createEmptyGeneratedKeysResultSet(this.connection);
            }
            int updateCount = this.getUpdateCount();
            return MySQLResultSet.createGeneratedKeysResultSet(insertId, updateCount, this.connection);
        }
        return MySQLResultSet.EMPTY;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.queryResult == null || this.queryResult.getResultSetType() != ResultSetType.SELECT) {
            return null;
        }
        return new MySQLResultSet(this.queryResult, this, this.protocol, this.connection.cal);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.queryResult == null || this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            return -1;
        }
        return (int)((ModifyQueryResult)this.queryResult).getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getMoreResults(boolean streaming) throws SQLException {
        try {
            MySQLProtocol mySQLProtocol = this.protocol;
            synchronized (mySQLProtocol) {
                if (this.queryResult != null) {
                    this.queryResult.close();
                }
                this.queryResult = this.protocol.getMoreResults(streaming);
                if (this.queryResult == null) {
                    return false;
                }
                this.warningsCleared = false;
                this.connection.reenableWarnings();
                return true;
            }
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, this.connection, this);
            return false;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (!this.isStreaming()) {
            if (this.cachedResultSets.isEmpty()) {
                this.queryResult = null;
                return false;
            }
            Object o = this.cachedResultSets.remove();
            if (o instanceof SQLException) {
                throw (SQLException)o;
            }
            this.queryResult = (QueryResult)o;
            return true;
        }
        return this.getMoreResults(false);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE) {
            throw new SQLException("invalid fetch size");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<Query>();
        }
        this.isInsertRewriteable(sql);
        this.batchQueries.add(new MySQLQuery(sql));
    }

    protected void isInsertRewriteable(String sql) {
        boolean isRewrite;
        if (!this.isRewriteable) {
            return;
        }
        int index = this.getInsertIncipit(sql);
        if (index == -1) {
            this.isRewriteable = false;
            return;
        }
        if (this.firstRewrite == null) {
            this.firstRewrite = sql.substring(0, index);
        }
        if (isRewrite = sql.startsWith(this.firstRewrite)) {
            this.isRewriteable = this.isRewriteable;
        }
    }

    protected int getInsertIncipit(String sql) {
        String sqlUpper = sql.toUpperCase();
        if (!sqlUpper.startsWith("INSERT")) {
            return -1;
        }
        int idx = sqlUpper.indexOf(" VALUE");
        int startBracket = sqlUpper.indexOf("(", idx);
        int endBracket = sqlUpper.indexOf(")", startBracket);
        int semicolonPos = sqlUpper.indexOf(59);
        while (semicolonPos > -1) {
            if (semicolonPos < startBracket || semicolonPos > endBracket) {
                return -1;
            }
            semicolonPos = sqlUpper.indexOf(59, semicolonPos + 1);
        }
        return startBracket;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
        this.firstRewrite = null;
        this.isRewriteable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchQueries == null || this.batchQueries.size() == 0) {
            return new int[0];
        }
        int[] ret = new int[this.batchQueries.size()];
        int i = 0;
        MySQLResultSet rs = null;
        boolean allowMultiQueries = "true".equals(this.getProtocol().getInfo().getProperty("allowMultiQueries"));
        boolean rewriteBatchedStatements = "true".equals(this.getProtocol().getInfo().getProperty("rewriteBatchedStatements"));
        if (rewriteBatchedStatements) {
            allowMultiQueries = true;
        }
        try {
            MySQLProtocol mySQLProtocol = this.protocol;
            synchronized (mySQLProtocol) {
                block13: {
                    if (!allowMultiQueries) break block13;
                    int size = this.batchQueries.size();
                    MySQLStatement ps = (MySQLStatement)this.connection.createStatement();
                    ps.execute(this.batchQueries, this.isRewriteable && rewriteBatchedStatements, this.isRewriteable && rewriteBatchedStatements ? this.firstRewrite.length() : 0);
                    int[] nArray = this.isRewriteable ? this.getUpdateCountsForReWrittenBatch(ps, size) : this.getUpdateCounts(ps, size);
                    return nArray;
                }
                while (i < this.batchQueries.size()) {
                    this.execute(this.batchQueries.get(i));
                    int updateCount = this.getUpdateCount();
                    ret[i] = updateCount == -1 ? -2 : updateCount;
                    rs = i == 0 ? (MySQLResultSet)this.getGeneratedKeys() : rs.joinResultSets((MySQLResultSet)this.getGeneratedKeys());
                    ++i;
                }
            }
        }
        catch (SQLException sqle) {
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), Arrays.copyOf(ret, i), (Throwable)sqle);
        }
        finally {
            this.clearBatch();
        }
        this.batchResultSet = rs;
        return ret;
    }

    protected int[] getUpdateCounts(Statement statement, int size) throws SQLException {
        int[] result = new int[size];
        for (int count = 0; count < size; ++count) {
            int updateCount = statement.getUpdateCount();
            result[count] = updateCount == -1 ? -2 : updateCount;
            statement.getMoreResults();
        }
        return result;
    }

    protected int[] getUpdateCountsForReWrittenBatch(Statement statement, int size) throws SQLException {
        int[] result = new int[size];
        int resultVal = statement.getUpdateCount() == size ? 1 : -2;
        for (int count = 0; count < size; ++count) {
            result[count] = resultVal;
        }
        return result;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    protected QueryResult getQueryResult() {
        return this.queryResult;
    }

    protected void setQueryResult(QueryResult result) {
        this.queryResult = result;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    public static void unloadDriver() {
        if (timer != null) {
            timer.cancel();
        }
    }
}

