/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mapstruct.ap.internal.model.AbstractMappingMethodBuilder;
import org.mapstruct.ap.internal.model.IterableCreation;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.LifecycleMethodResolver;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NormalTypeMappingMethod;
import org.mapstruct.ap.internal.model.ObjectFactoryMethodResolver;
import org.mapstruct.ap.internal.model.assignment.LocalVarWrapper;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.ForgedMethod;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Strings;

public class MapMappingMethod
extends NormalTypeMappingMethod {
    private final Assignment keyAssignment;
    private final Assignment valueAssignment;
    private IterableCreation iterableCreation;

    private MapMappingMethod(Method method, Collection<String> existingVariableNames, Assignment keyAssignment, Assignment valueAssignment, MethodReference factoryMethod, boolean mapNullToDefault, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences) {
        super(method, existingVariableNames, factoryMethod, mapNullToDefault, beforeMappingReferences, afterMappingReferences);
        this.keyAssignment = keyAssignment;
        this.valueAssignment = valueAssignment;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget() || parameter.isMappingContext()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public List<Type> getSourceElementTypes() {
        Type sourceParameterType = this.getSourceParameter().getType();
        return sourceParameterType.determineTypeArguments(Map.class);
    }

    public List<Type> getResultElementTypes() {
        return this.getResultType().determineTypeArguments(Map.class);
    }

    public Assignment getKeyAssignment() {
        return this.keyAssignment;
    }

    public Assignment getValueAssignment() {
        return this.valueAssignment;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        if (this.keyAssignment != null) {
            types.addAll(this.keyAssignment.getImportTypes());
        }
        if (this.valueAssignment != null) {
            types.addAll(this.valueAssignment.getImportTypes());
        }
        if (this.iterableCreation != null) {
            types.addAll(this.iterableCreation.getImportTypes());
        }
        return types;
    }

    public String getKeyVariableName() {
        return Strings.getSafeVariableName("key", this.getParameterNames());
    }

    public String getValueVariableName() {
        return Strings.getSafeVariableName("value", this.getParameterNames());
    }

    public String getEntryVariableName() {
        return Strings.getSafeVariableName("entry", this.getParameterNames());
    }

    public IterableCreation getIterableCreation() {
        if (this.iterableCreation == null) {
            this.iterableCreation = IterableCreation.create(this, this.getSourceParameter());
        }
        return this.iterableCreation;
    }

    public static class Builder
    extends AbstractMappingMethodBuilder<Builder, MapMappingMethod> {
        private FormattingParameters keyFormattingParameters;
        private FormattingParameters valueFormattingParameters;
        private NullValueMappingStrategyPrism nullValueMappingStrategy;
        private SelectionParameters keySelectionParameters;
        private SelectionParameters valueSelectionParameters;

        public Builder() {
            super(Builder.class);
        }

        public Builder keySelectionParameters(SelectionParameters keySelectionParameters) {
            this.keySelectionParameters = keySelectionParameters;
            return this;
        }

        public Builder valueSelectionParameters(SelectionParameters valueSelectionParameters) {
            this.valueSelectionParameters = valueSelectionParameters;
            return this;
        }

        public Builder keyFormattingParameters(FormattingParameters keyFormattingParameters) {
            this.keyFormattingParameters = keyFormattingParameters;
            return this;
        }

        public Builder valueFormattingParameters(FormattingParameters valueFormattingParameters) {
            this.valueFormattingParameters = valueFormattingParameters;
            return this;
        }

        public Builder nullValueMappingStrategy(NullValueMappingStrategyPrism nullValueMappingStrategy) {
            this.nullValueMappingStrategy = nullValueMappingStrategy;
            return this;
        }

        @Override
        public MapMappingMethod build() {
            List<Type> sourceTypeParams = Collections.first(this.method.getSourceParameters()).getType().determineTypeArguments(Map.class);
            List<Type> resultTypeParams = this.method.getResultType().determineTypeArguments(Map.class);
            Type keySourceType = sourceTypeParams.get(0).getTypeBound();
            Type keyTargetType = resultTypeParams.get(0).getTypeBound();
            SourceRHS keySourceRHS = new SourceRHS("entry.getKey()", keySourceType, new HashSet<String>(), "map key");
            Assignment keyAssignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, keyTargetType, null, this.keyFormattingParameters, this.keySelectionParameters, keySourceRHS, false, null);
            if (keyAssignment == null) {
                keyAssignment = this.forgeMapping(keySourceRHS, keySourceType, keyTargetType);
            }
            if (keyAssignment == null) {
                if (this.method instanceof ForgedMethod) {
                    return null;
                }
                this.reportCannotCreateMapping(this.method, String.format("%s \"%s\"", keySourceRHS.getSourceErrorMessagePart(), keySourceRHS.getSourceType()), keySourceRHS.getSourceType(), keyTargetType, "");
            }
            Type valueSourceType = sourceTypeParams.get(1).getTypeBound();
            Type valueTargetType = resultTypeParams.get(1).getTypeBound();
            SourceRHS valueSourceRHS = new SourceRHS("entry.getValue()", valueSourceType, new HashSet<String>(), "map value");
            Assignment valueAssignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, valueTargetType, null, this.valueFormattingParameters, this.valueSelectionParameters, valueSourceRHS, false, null);
            if (this.method instanceof ForgedMethod) {
                ForgedMethod forgedMethod = (ForgedMethod)this.method;
                if (keyAssignment != null) {
                    forgedMethod.addThrownTypes(keyAssignment.getThrownTypes());
                }
                if (valueAssignment != null) {
                    forgedMethod.addThrownTypes(valueAssignment.getThrownTypes());
                }
            }
            if (valueAssignment == null) {
                valueAssignment = this.forgeMapping(valueSourceRHS, valueSourceType, valueTargetType);
            }
            if (valueAssignment == null) {
                if (this.method instanceof ForgedMethod) {
                    return null;
                }
                this.reportCannotCreateMapping(this.method, String.format("%s \"%s\"", valueSourceRHS.getSourceErrorMessagePart(), valueSourceRHS.getSourceType()), valueSourceRHS.getSourceType(), valueTargetType, "");
            }
            boolean mapNullToDefault = false;
            if (this.method.getMapperConfiguration() != null) {
                mapNullToDefault = this.method.getMapperConfiguration().isMapToDefault(this.nullValueMappingStrategy);
            }
            MethodReference factoryMethod = null;
            if (!this.method.isUpdateMethod()) {
                factoryMethod = ObjectFactoryMethodResolver.getFactoryMethod(this.method, this.method.getResultType(), null, this.ctx);
            }
            keyAssignment = new LocalVarWrapper(keyAssignment, this.method.getThrownTypes(), keyTargetType, false);
            valueAssignment = new LocalVarWrapper(valueAssignment, this.method.getThrownTypes(), valueTargetType, false);
            HashSet<String> existingVariables = new HashSet<String>(this.method.getParameterNames());
            List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleMethodResolver.beforeMappingMethods(this.method, null, this.ctx, existingVariables);
            List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleMethodResolver.afterMappingMethods(this.method, null, this.ctx, existingVariables);
            return new MapMappingMethod(this.method, existingVariables, keyAssignment, valueAssignment, factoryMethod, mapNullToDefault, beforeMappingMethods, afterMappingMethods);
        }

        @Override
        protected boolean shouldUsePropertyNamesInHistory() {
            return true;
        }
    }
}

