/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.reactivestreams;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import java.util.Arrays;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bson.codecs.configuration.CodecRegistry;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.service.ClassMappingType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/litote/kmongo/reactivestreams/KMongo;", "", "<init>", "()V", "createClient", "Lcom/mongodb/reactivestreams/client/MongoClient;", "settings", "Lcom/mongodb/MongoClientSettings;", "connectionString", "", "Lcom/mongodb/ConnectionString;", "configureRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "codecRegistry", "configureRegistry$kmongo_async_shared", "kmongo-async-shared"})
public final class KMongo {
    @NotNull
    public static final KMongo INSTANCE = new KMongo();

    private KMongo() {
    }

    @NotNull
    public final MongoClient createClient() {
        return this.createClient(new ConnectionString("mongodb://localhost"));
    }

    @NotNull
    public final MongoClient createClient(@NotNull MongoClientSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CodecRegistry codecRegistry = settings.getCodecRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)codecRegistry, (String)"getCodecRegistry(...)");
        CodecRegistry codecRegistry2 = ClassMappingType.INSTANCE.codecRegistry(codecRegistry);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder((MongoClientSettings)settings).codecRegistry(codecRegistry2).build();
        MongoDriverInformation.Builder builder = MongoDriverInformation.builder().driverName("kmongo");
        String string = "Kotlin/%s";
        Object[] objectArray = new Object[]{KotlinVersion.CURRENT};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings, (MongoDriverInformation)builder.driverPlatform(string2).build());
        Intrinsics.checkNotNullExpressionValue((Object)mongoClient, (String)"create(...)");
        return mongoClient;
    }

    @NotNull
    public final MongoClient createClient(@NotNull String connectionString) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        return this.createClient(new ConnectionString(connectionString));
    }

    @NotNull
    public final MongoClient createClient(@NotNull ConnectionString connectionString) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        Intrinsics.checkNotNullExpressionValue((Object)mongoClientSettings, (String)"build(...)");
        return this.createClient(mongoClientSettings);
    }

    @NotNull
    public final CodecRegistry configureRegistry$kmongo_async_shared(@NotNull CodecRegistry codecRegistry) {
        Intrinsics.checkNotNullParameter((Object)codecRegistry, (String)"codecRegistry");
        return ClassMappingType.INSTANCE.codecRegistry(codecRegistry);
    }
}

