/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.changelog;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import java.util.ArrayList;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.RunCommandStatement;
import org.bson.Document;
import org.bson.conversions.Bson;

public class AdjustChangeLogCollectionStatement
extends RunCommandStatement {
    public static final String UI = "ui_";
    public static String OPTIONS = "{ collMod: \"%s\",\n\"validator\": {    \"$jsonSchema\": {\n    \"bsonType\": \"object\",\n    \"description\": \"Database Change Log Table.\",\n    \"required\": [\"id\", \"author\", \"fileName\", \"execType\"],\n    \"properties\": \n    {\n        \"id\": {\n            \"bsonType\": \"string\",\n            \"description\": \"Value from the changeSet id attribute.\"\n        },\n        \"author\": {\n            \"bsonType\": \"string\",\n            \"description\": \"Value from the changeSet author attribute.\"\n        },\n        \"fileName\": {\n            \"bsonType\": \"string\",\n            \"description\": \"Path to the changelog. This may be an absolute path or a relative path depending on how the changelog was passed to Liquibase. For best results, it should be a relative path.\"\n        },\n        \"dateExecuted\": {\n            \"bsonType\": [\"date\", \"null\"],\n            \"description\": \"Date/time of when the changeSet was executed. Used with orderExecuted to determine rollback order.\"\n        },\n        \"orderExecuted\": {\n            \"bsonType\": [\"int\", \"null\"],\n            \"description\": \"Order that the changeSets were executed. Used in addition to dateExecuted to ensure order is correct even when the databases datetime supports poor resolution.\"\n        },\n        \"execType\": {\n            \"bsonType\": \"string\",\n            \"enum\": [\"EXECUTED\", \"FAILED\", \"SKIPPED\", \"RERAN\", \"MARK_RAN\"],\n            \"description\": \"Description of how the changeSet was executed.\"\n        },\n        \"md5sum\": {\n            \"bsonType\": [\"string\", \"null\"],\n            \"description\": \"Checksum of the changeSet when it was executed. Used on each run to ensure there have been no unexpected changes to changSet in the changelog file.\"\n        },\n        \"description\": {\n            \"bsonType\": [\"string\", \"null\"],\n            \"description\": \"Short auto-generated human readable description of changeSet.\"\n        },\n        \"comments\": {\n            \"bsonType\": [\"string\", \"null\"],\n            \"description\": \"Value from the changeSet comment attribute.\"\n        },\n        \"tag\": {\n            \"bsonType\": [\"string\", \"null\"],\n            \"description\": \"Tracks which changeSets correspond to tag operations.\"\n        },\n        \"contexts\": {\n            \"bsonType\": [\"string\", \"null\"],\n            \"description\": \"Context expression of the run.\"\n        },\n        \"labels\": {\n            \"bsonType\": [\"string\", \"null\"],\n            \"description\": \"Labels assigned.\"\n        },\n        \"deploymentId\": {\n            \"bsonType\": [\"string\", \"null\"],\n            \"description\": \"Unique identifier generate for a run.\"\n        },\n        \"liquibase\": {\n            \"bsonType\": [\"string\", \"null\"],\n            \"description\": \"Version of Liquibase used to execute the changeSet.\"\n        }\n    }\n   }},\"validationLevel\": \"strict\",\n\"validationAction\": \"error\"\n}";
    private final String collectionName;

    public AdjustChangeLogCollectionStatement(String collectionName) {
        super(String.format(OPTIONS, collectionName));
        this.collectionName = collectionName;
    }

    @Override
    public String getCommandName() {
        return "runCommand";
    }

    @Override
    public void execute(MongoLiquibaseDatabase database) {
        this.adjustIndexes(database);
        if (database.getSupportsValidator().booleanValue()) {
            super.execute(database);
        }
    }

    private void adjustIndexes(MongoLiquibaseDatabase database) {
        MongoCollection collection = database.getMongoDatabase().getCollection(this.getCollectionName());
        ArrayList indexes = new ArrayList();
        collection.listIndexes().into(indexes);
        if (indexes.size() == 1) {
            Document keys = new Document().append("fileName", (Object)1).append("author", (Object)1).append("id", (Object)1);
            IndexOptions options = new IndexOptions().name(UI + this.getCollectionName()).unique(true);
            collection.createIndex((Bson)keys, options);
        }
    }

    @Override
    public Document run(MongoLiquibaseDatabase database) {
        return database.getMongoDatabase().runCommand((Bson)this.command);
    }

    public String getCollectionName() {
        return this.collectionName;
    }
}

