/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.validator;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectAnnotationReader;
import org.linkki.tooling.apt.model.AptAspectSubject;
import org.linkki.tooling.apt.model.AptPmo;
import org.linkki.tooling.apt.util.ClassNotFoundMessageUtils;
import org.linkki.tooling.apt.util.DynamicAspectMethodName;
import org.linkki.tooling.apt.util.DynamicMethodUtils;
import org.linkki.tooling.apt.util.ElementUtils;
import org.linkki.tooling.apt.util.MethodNameUtils;
import org.linkki.tooling.apt.util.SuppressedWarningsUtils;
import org.linkki.tooling.apt.validator.MessageCodes;
import org.linkki.tooling.apt.validator.Messages;
import org.linkki.tooling.apt.validator.Severity;
import org.linkki.tooling.apt.validator.Validator;

@MessageCodes(value={"MISSING_METHOD_ABSTRACT_TYPE", "MISSING_METHOD"})
public class AspectMethodValidator
implements Validator {
    public static final String MISSING_METHOD = "MISSING_METHOD";
    public static final String MISSING_METHOD_ABSTRACT_TYPE = "MISSING_METHOD_ABSTRACT_TYPE";
    private final Diagnostic.Kind missingAspectMethodSeverity;
    private final Diagnostic.Kind missingAspectMethodAbstractTypeSeverity;
    private final ElementUtils elementUtils;

    public AspectMethodValidator(Map<String, String> options, ElementUtils elementUtils) {
        this.elementUtils = elementUtils;
        this.missingAspectMethodSeverity = Severity.of(options, MISSING_METHOD, Diagnostic.Kind.ERROR);
        this.missingAspectMethodAbstractTypeSeverity = Severity.of(options, MISSING_METHOD_ABSTRACT_TYPE, Diagnostic.Kind.ERROR);
    }

    @Override
    public void validate(AptPmo pmo, Messager messager) {
        if (pmo.isAbstractType()) {
            if (this.missingAspectMethodAbstractTypeSeverity == Diagnostic.Kind.OTHER) {
                return;
            }
            if (SuppressedWarningsUtils.isSuppressed(pmo.getElement(), this.missingAspectMethodAbstractTypeSeverity)) {
                return;
            }
            this.printMessages(messager, pmo, this.missingAspectMethodAbstractTypeSeverity, MISSING_METHOD_ABSTRACT_TYPE);
        } else {
            if (this.missingAspectMethodSeverity == Diagnostic.Kind.OTHER) {
                return;
            }
            if (SuppressedWarningsUtils.isSuppressed(pmo.getElement(), this.missingAspectMethodSeverity)) {
                return;
            }
            this.printMessages(messager, pmo, this.missingAspectMethodSeverity, MISSING_METHOD);
        }
    }

    private void printMessages(Messager messager, AptPmo pmo, Diagnostic.Kind kind, String messageCode) {
        pmo.getComponents().stream().flatMap(component -> Stream.concat(component.getAspectBindings().stream(), component.getComponentDeclarations().stream())).filter(aspectSubject -> !SuppressedWarningsUtils.isSuppressed(aspectSubject.getElement(), kind)).forEach(aspectSubject -> {
            TypeElement annotationElement = (TypeElement)aspectSubject.getAnnotationMirror().getAnnotationType().asElement();
            try {
                this.checkAspects(messager, this.elementUtils.getAllMethods(pmo.getElement()), (AptAspectSubject)aspectSubject, this.elementUtils.getAnnotationType(annotationElement), kind, messageCode);
            }
            catch (ClassNotFoundException e) {
                ClassNotFoundMessageUtils.printAnnotationNotFoundWarning(messager, aspectSubject.getElement(), aspectSubject.getAnnotationMirror());
            }
        });
    }

    private void checkAspects(Messager messager, Set<ExecutableElement> allMethods, AptAspectSubject aspectSubject, Class<? extends Annotation> annotationType, Diagnostic.Kind kind, String messageCode) {
        Annotation annotation = Objects.requireNonNull(aspectSubject.getElement().getAnnotation(annotationType), "annotation was null");
        List aspectDefinitions = AspectAnnotationReader.createAspectDefinitionsFrom((Annotation)annotation);
        Set<DynamicAspectMethodName> expectedMethods = DynamicMethodUtils.getExpectedMethods(aspectSubject.getElement(), aspectDefinitions, messager);
        expectedMethods.stream().filter(expectedMethod -> this.isMissing(allMethods, (DynamicAspectMethodName)expectedMethod)).forEach(it -> {
            String propertyName = MethodNameUtils.getPropertyName(aspectSubject.getElement());
            String message = Messages.format(messageCode, aspectSubject.getAnnotationMirror(), it.getExpectedMethodName(), propertyName);
            messager.printMessage(kind, message, aspectSubject.getElement(), aspectSubject.getAnnotationMirror());
        });
    }

    private boolean isMissing(Set<ExecutableElement> allMethods, DynamicAspectMethodName expectedMethod) {
        String expectedMethodName = expectedMethod.getExpectedMethodName();
        return allMethods.stream().map(ExecutableElement::getSimpleName).map(Object::toString).noneMatch(it -> it.equals(expectedMethodName));
    }
}

