/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public final class SuppressedWarningsUtils {
    private static final Set<String> SUPPORTED_SUPPRESSABLE_WARNINGS = new HashSet<String>(Arrays.asList("all", "linkki"));

    private SuppressedWarningsUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSuppressed(Element element) {
        SuppressWarnings annotation = element.getAnnotation(SuppressWarnings.class);
        if (annotation == null) return false;
        if (!Stream.of(annotation.value()).anyMatch(SUPPORTED_SUPPRESSABLE_WARNINGS::contains)) return false;
        return true;
    }

    public static boolean isSuppressed(Element element, Diagnostic.Kind kind) {
        return kind == Diagnostic.Kind.WARNING && SuppressedWarningsUtils.isSuppressed(element);
    }
}

