/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectAnnotationReader;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.base.ModelToUiAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.ui.aspects.AvailableValuesAspectDefinition;
import org.linkki.tooling.apt.util.DynamicAspectMethodName;
import org.linkki.tooling.apt.validator.Messages;
import org.linkki.util.Optionals;

public final class DynamicMethodUtils {
    public static final String ASPECT_CREATION_FAILED = "ASPECT_CREATION_FAILED";

    private DynamicMethodUtils() {
    }

    public static Set<DynamicAspectMethodName> getExpectedMethods(ExecutableElement method, Annotation annotation, Messager messager) {
        List aspectDefinitions = AspectAnnotationReader.createAspectDefinitionsFrom((Annotation)annotation);
        return DynamicMethodUtils.getExpectedMethods(method, aspectDefinitions, messager);
    }

    public static Set<DynamicAspectMethodName> getExpectedMethods(ExecutableElement method, List<LinkkiAspectDefinition> aspectDefinitions, Messager messager) {
        Set<DynamicAspectMethodName> expectedMethodsFromAvailableValuesAspectDefinitions = DynamicMethodUtils.getExpectedMethodsFromAvailableValuesAspectDefinition(method, aspectDefinitions, messager);
        Set<DynamicAspectMethodName> expectedMethodsFromModelToUiAspectDefinition = DynamicMethodUtils.getExpectedMethodsFromModelToUiAspectDefinition(method, aspectDefinitions, messager);
        Set<DynamicAspectMethodName> expectedMethodsFromCompositeAspectDefinition = DynamicMethodUtils.getExpectedMethodsFromCompositeAspectDefinition(method, aspectDefinitions, messager);
        return Stream.of(expectedMethodsFromAvailableValuesAspectDefinitions, expectedMethodsFromModelToUiAspectDefinition, expectedMethodsFromCompositeAspectDefinition).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<DynamicAspectMethodName> getExpectedMethodsFromCompositeAspectDefinition(ExecutableElement method, List<LinkkiAspectDefinition> aspectDefinitions, Messager messager) {
        return aspectDefinitions.stream().filter(CompositeAspectDefinition.class::isInstance).map(CompositeAspectDefinition.class::cast).flatMap(it -> {
            try {
                Field field = CompositeAspectDefinition.class.getDeclaredField("aspectDefinitions");
                field.setAccessible(true);
                List innerAspectDefinitions = (List)field.get(it);
                return DynamicMethodUtils.getExpectedMethods(method, innerAspectDefinitions, messager).stream();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet());
    }

    private static Set<DynamicAspectMethodName> getExpectedMethodsFromModelToUiAspectDefinition(ExecutableElement method, List<LinkkiAspectDefinition> aspectDefinitions, Messager messager) {
        return aspectDefinitions.stream().filter(ModelToUiAspectDefinition.class::isInstance).map(ModelToUiAspectDefinition.class::cast).map(it -> DynamicMethodUtils.createAspect(it, (Element)method, messager).map(aspect -> new AspectInfo((Aspect<?>)aspect, DynamicMethodUtils.isBooleanModelToUiAspectDefinition(it)))).flatMap(Optionals::stream).filter(it -> !it.getAspect().isValuePresent()).filter(it -> !it.getAspect().getName().isEmpty()).map(it -> new DynamicAspectMethodName(method, it.getAspect().getName(), it.isBooleanModelToUiAspectDefinition())).collect(Collectors.toSet());
    }

    private static Set<DynamicAspectMethodName> getExpectedMethodsFromAvailableValuesAspectDefinition(ExecutableElement method, List<LinkkiAspectDefinition> aspectDefinitions, Messager messager) {
        return aspectDefinitions.stream().filter(AvailableValuesAspectDefinition.class::isInstance).map(AvailableValuesAspectDefinition.class::cast).map(it -> DynamicMethodUtils.createAspect(it, (Element)method, messager)).flatMap(Optionals::stream).filter(it -> !it.isValuePresent()).filter(it -> !it.getName().isEmpty()).map(it -> new DynamicAspectMethodName(method, it.getName(), false)).collect(Collectors.toSet());
    }

    private static Optional<Aspect<?>> createAspect(ModelToUiAspectDefinition<?> aspectDefinition, Element method, Messager messager) {
        try {
            return Optional.of(aspectDefinition.createAspect());
        }
        catch (RuntimeException e) {
            String msg = String.format(Messages.getString(ASPECT_CREATION_FAILED), aspectDefinition.getClass().getSimpleName(), e.getMessage());
            messager.printMessage(Diagnostic.Kind.WARNING, msg, method);
            return Optional.empty();
        }
    }

    private static Optional<Aspect<?>> createAspect(AvailableValuesAspectDefinition<?> aspectDefinition, Element method, Messager messager) {
        try {
            return Optional.of(aspectDefinition.createAspect(VisibleType.class));
        }
        catch (RuntimeException e) {
            String msg = String.format(Messages.getString(ASPECT_CREATION_FAILED), aspectDefinition.getClass().getSimpleName(), e.getMessage());
            messager.printMessage(Diagnostic.Kind.WARNING, msg, method);
            return Optional.empty();
        }
    }

    private static boolean isBooleanModelToUiAspectDefinition(ModelToUiAspectDefinition<?> aspectDefinition) {
        Class<?> currentClass = aspectDefinition.getClass();
        Class<?> superClass = currentClass.getSuperclass();
        while (!superClass.equals(ModelToUiAspectDefinition.class)) {
            if (superClass.equals(LinkkiAspectDefinition.class)) {
                return false;
            }
            currentClass = superClass;
            superClass = superClass.getSuperclass();
        }
        Type genericSuperclass = currentClass.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            return Arrays.asList(((ParameterizedType)genericSuperclass).getActualTypeArguments()).stream().anyMatch(it -> it.getTypeName().equals(Boolean.TYPE.getTypeName()) || it.getTypeName().equals(Boolean.class.getTypeName()));
        }
        return false;
    }

    public static List<Aspect<?>> getAspects(final ExecutableElement method, final LinkkiAspectDefinition aspectDefinition) {
        if (aspectDefinition instanceof ModelToUiAspectDefinition) {
            return Arrays.asList(((ModelToUiAspectDefinition)aspectDefinition).createAspect());
        }
        if (aspectDefinition instanceof AvailableValuesAspectDefinition) {
            return Arrays.asList(((AvailableValuesAspectDefinition)aspectDefinition).createAspect(VisibleType.class));
        }
        if (aspectDefinition instanceof CompositeAspectDefinition) {
            return (List)AccessController.doPrivileged(new PrivilegedAction<List<Aspect<?>>>(){

                @Override
                public List<Aspect<?>> run() {
                    try {
                        Field field = CompositeAspectDefinition.class.getDeclaredField("aspectDefinitions");
                        field.setAccessible(true);
                        List innerAspectDefinitions = (List)field.get(aspectDefinition);
                        return innerAspectDefinitions.stream().flatMap(it -> DynamicMethodUtils.getAspects(method, it).stream()).collect(Collectors.toList());
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return Collections.emptyList();
    }

    private static class AspectInfo {
        private final Aspect<?> aspect;
        private final boolean isBooleanModelToUiAspectDefinition;

        public AspectInfo(Aspect<?> aspect, boolean isBooleanModelToUiAspectDefinition) {
            this.aspect = aspect;
            this.isBooleanModelToUiAspectDefinition = isBooleanModelToUiAspectDefinition;
        }

        public Aspect<?> getAspect() {
            return this.aspect;
        }

        public boolean isBooleanModelToUiAspectDefinition() {
            return this.isBooleanModelToUiAspectDefinition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.aspect.hashCode();
            result = 31 * result + (this.isBooleanModelToUiAspectDefinition ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AspectInfo other = (AspectInfo)obj;
            if (!this.aspect.equals(other.aspect)) {
                return false;
            }
            return this.isBooleanModelToUiAspectDefinition == other.isBooleanModelToUiAspectDefinition;
        }
    }
}

