/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class Optionals {
    private Optionals() {
    }

    public static <T> void ifPresentOrElse(Optional<T> optional, Consumer<? super T> action, Runnable emptyAction) {
        if (optional.isPresent()) {
            action.accept(optional.get());
        } else {
            emptyAction.run();
        }
    }

    public static <T> Stream<T> stream(Optional<T> o) {
        return o.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> Either<T> either(Optional<T> o) {
        return new Either<T>(o);
    }

    public static class Either<T> {
        private final Optional<T> thiz;

        Either(Optional<T> o) {
            this.thiz = Objects.requireNonNull(o, "o must not be null");
        }

        public Optional<T> or(Supplier<? extends Optional<? extends T>> supplier) {
            Objects.requireNonNull(supplier);
            if (this.thiz.isPresent()) {
                return this.thiz;
            }
            Optional<? extends T> r = supplier.get();
            return Objects.requireNonNull(r);
        }
    }
}

