/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.linkki.util.LookupProvider;

public class MemberAccessors {
    private static final Map<Member, Function<Object, Object>> ACCESSOR_CACHE = new ConcurrentHashMap<Member, Function<Object, Object>>();
    private final Method method;

    private MemberAccessors(Method method) {
        this.method = method;
    }

    private Function<Object, Object> createFunction() {
        if (Void.TYPE.equals(this.method.getReturnType())) {
            throw new IllegalArgumentException("Cannot call void method using " + this);
        }
        MethodHandles.Lookup lookup = LookupProvider.lookup(this.method.getDeclaringClass());
        MethodHandle methodHandle = this.getMethodHandle(lookup);
        CallSite site = this.getCallSite(lookup, methodHandle);
        try {
            return site.getTarget().invoke();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Cannot create getter function for " + this, e);
        }
    }

    private MethodHandle getMethodHandle(MethodHandles.Lookup lookup) {
        try {
            return lookup.unreflect(this.method);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't get " + MethodHandle.class.getSimpleName() + " for " + this, e);
        }
    }

    private CallSite getCallSite(MethodHandles.Lookup lookup, MethodHandle methodHandle) {
        try {
            return LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), methodHandle, methodHandle.type());
        }
        catch (LambdaConversionException e) {
            throw new IllegalArgumentException("Can't create " + CallSite.class.getSimpleName() + " for " + methodHandle, e);
        }
    }

    public String toString() {
        return "accessor to " + MemberAccessors.getNameOf(this.method);
    }

    public static <T> T getValue(Object object, Member fieldOrMethod) {
        if (fieldOrMethod instanceof Field) {
            return (T)MemberAccessors.getFieldValue(object, fieldOrMethod);
        }
        if (fieldOrMethod instanceof Method) {
            Function accessor = ACCESSOR_CACHE.computeIfAbsent(fieldOrMethod, key -> new MemberAccessors((Method)key).createFunction());
            return (T)accessor.apply(object);
        }
        throw new IllegalArgumentException("Only field or method is supported, found " + fieldOrMethod.getClass().getCanonicalName() + " as type of " + MemberAccessors.getNameOf(fieldOrMethod));
    }

    private static Object getFieldValue(Object object, Member fieldOrMethod) {
        try {
            Field field = (Field)fieldOrMethod;
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access field " + fieldOrMethod, e);
        }
    }

    private static String getNameOf(Member member) {
        return member.getDeclaringClass().getCanonicalName() + "#" + member.getName();
    }
}

