/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;
import org.kohsuke.github.Requester;
import org.kohsuke.github.SkipFromToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GHIssue
extends GHObject
implements Reactable {
    private static final String ASSIGNEES = "assignees";
    GitHub root;
    GHRepository owner;
    protected GHUser assignee;
    protected GHUser[] assignees;
    protected String state;
    protected int number;
    protected String closed_at;
    protected int comments;
    @SkipFromToString
    protected String body;
    protected List<Label> labels;
    protected GHUser user;
    protected String title;
    protected String html_url;
    protected PullRequest pull_request;
    protected GHMilestone milestone;
    protected GHUser closed_by;
    protected boolean locked;

    GHIssue wrap(GHRepository owner) {
        this.owner = owner;
        if (this.milestone != null) {
            this.milestone.wrap(owner);
        }
        return this.wrap(owner.root);
    }

    GHIssue wrap(GitHub root) {
        this.root = root;
        if (this.assignee != null) {
            this.assignee.wrapUp(root);
        }
        if (this.assignees != null) {
            GHUser.wrap(this.assignees, root);
        }
        if (this.user != null) {
            this.user.wrapUp(root);
        }
        if (this.closed_by != null) {
            this.closed_by.wrapUp(root);
        }
        return this;
    }

    static GHIssue[] wrap(GHIssue[] issues, GHRepository owner) {
        for (GHIssue i : issues) {
            i.wrap(owner);
        }
        return issues;
    }

    public GHRepository getRepository() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public GHIssueState getState() {
        return Enum.valueOf(GHIssueState.class, this.state.toUpperCase(Locale.ENGLISH));
    }

    public Collection<GHLabel> getLabels() throws IOException {
        if (this.labels == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.labels);
    }

    public Date getClosedAt() {
        return GitHub.parseDate(this.closed_at);
    }

    public URL getApiURL() {
        return GitHub.parseURL(this.url);
    }

    public void lock() throws IOException {
        new Requester(this.root).method("PUT").to(this.getApiRoute() + "/lock");
    }

    public void unlock() throws IOException {
        new Requester(this.root).method("PUT").to(this.getApiRoute() + "/lock");
    }

    @WithBridgeMethods(value={void.class})
    public GHIssueComment comment(String message) throws IOException {
        GHIssueComment r = (GHIssueComment)((Object)new Requester(this.root).with("body", message).to(this.getIssuesApiRoute() + "/comments", GHIssueComment.class));
        return r.wrapUp(this);
    }

    private void edit(String key, Object value) throws IOException {
        new Requester(this.root)._with(key, value).method("PATCH").to(this.getApiRoute());
    }

    private void editIssue(String key, Object value) throws IOException {
        new Requester(this.root)._with(key, value).method("PATCH").to(this.getIssuesApiRoute());
    }

    public void close() throws IOException {
        this.edit("state", "closed");
    }

    public void reopen() throws IOException {
        this.edit("state", "open");
    }

    public void setTitle(String title) throws IOException {
        this.edit("title", title);
    }

    public void setBody(String body) throws IOException {
        this.edit("body", body);
    }

    public void setMilestone(GHMilestone milestone) throws IOException {
        this.edit("milestone", milestone.getNumber());
    }

    public void assignTo(GHUser user) throws IOException {
        this.setAssignees(user);
    }

    public void setLabels(String ... labels) throws IOException {
        this.editIssue("labels", labels);
    }

    public List<GHIssueComment> getComments() throws IOException {
        return this.listComments().asList();
    }

    public PagedIterable<GHIssueComment> listComments() throws IOException {
        return new PagedIterable<GHIssueComment>(){

            @Override
            public PagedIterator<GHIssueComment> _iterator(int pageSize) {
                return new PagedIterator<GHIssueComment>(GHIssue.this.root.retrieve().asIterator(GHIssue.this.getIssuesApiRoute() + "/comments", GHIssueComment[].class, pageSize)){

                    protected void wrapUp(GHIssueComment[] page) {
                        for (GHIssueComment c : page) {
                            c.wrapUp(GHIssue.this);
                        }
                    }
                };
            }
        };
    }

    @Override
    @Preview
    @Deprecated
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return ((GHReaction)((Object)new Requester(this.owner.root).withPreview("application/vnd.github.squirrel-girl-preview").with("content", content.getContent()).to(this.getApiRoute() + "/reactions", GHReaction.class))).wrap(this.root);
    }

    @Override
    @Preview
    @Deprecated
    public PagedIterable<GHReaction> listReactions() {
        return new PagedIterable<GHReaction>(){

            @Override
            public PagedIterator<GHReaction> _iterator(int pageSize) {
                return new PagedIterator<GHReaction>(GHIssue.this.owner.root.retrieve().withPreview("application/vnd.github.squirrel-girl-preview").asIterator(GHIssue.this.getApiRoute() + "/reactions", GHReaction[].class, pageSize)){

                    protected void wrapUp(GHReaction[] page) {
                        for (GHReaction c : page) {
                            c.wrap(GHIssue.this.owner.root);
                        }
                    }
                };
            }
        };
    }

    public void addAssignees(GHUser ... assignees) throws IOException {
        this.addAssignees(Arrays.asList(assignees));
    }

    public void addAssignees(Collection<GHUser> assignees) throws IOException {
        this.root.retrieve().method("POST").withLogins(ASSIGNEES, assignees).to(this.getIssuesApiRoute() + "/assignees", this);
    }

    public void setAssignees(GHUser ... assignees) throws IOException {
        this.setAssignees(Arrays.asList(assignees));
    }

    public void setAssignees(Collection<GHUser> assignees) throws IOException {
        new Requester(this.root).withLogins(ASSIGNEES, assignees).method("PATCH").to(this.getIssuesApiRoute());
    }

    public void removeAssignees(GHUser ... assignees) throws IOException {
        this.removeAssignees(Arrays.asList(assignees));
    }

    public void removeAssignees(Collection<GHUser> assignees) throws IOException {
        this.root.retrieve().method("DELETE").withLogins(ASSIGNEES, assignees).inBody().to(this.getIssuesApiRoute() + "/assignees", this);
    }

    protected String getApiRoute() {
        return this.getIssuesApiRoute();
    }

    protected String getIssuesApiRoute() {
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/issues/" + this.number;
    }

    public GHUser getAssignee() throws IOException {
        return this.root.intern(this.assignee);
    }

    public List<GHUser> getAssignees() {
        return Collections.unmodifiableList(Arrays.asList(this.assignees));
    }

    public GHUser getUser() throws IOException {
        return this.root.intern(this.user);
    }

    public GHUser getClosedBy() throws IOException {
        if (!"closed".equals(this.state)) {
            return null;
        }
        return this.root.intern(this.closed_by);
    }

    public int getCommentsCount() {
        return this.comments;
    }

    public PullRequest getPullRequest() {
        return this.pull_request;
    }

    public boolean isPullRequest() {
        return this.pull_request != null;
    }

    public GHMilestone getMilestone() {
        return this.milestone;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class PullRequest {
        private String diff_url;
        private String patch_url;
        private String html_url;

        public URL getDiffUrl() {
            return GitHub.parseURL(this.diff_url);
        }

        public URL getPatchUrl() {
            return GitHub.parseURL(this.patch_url);
        }

        public URL getUrl() {
            return GitHub.parseURL(this.html_url);
        }
    }

    public static class Label
    extends GHLabel {
    }
}

