/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import org.kohsuke.github.GHDeploymentState;
import org.kohsuke.github.GHDeploymentStatus;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public class GHDeploymentStatusBuilder {
    private final Requester builder;
    private GHRepository repo;
    private long deploymentId;

    public GHDeploymentStatusBuilder(GHRepository repo, int deploymentId, GHDeploymentState state) {
        this(repo, (long)deploymentId, state);
    }

    GHDeploymentStatusBuilder(GHRepository repo, long deploymentId, GHDeploymentState state) {
        this.repo = repo;
        this.deploymentId = deploymentId;
        this.builder = new Requester(repo.root);
        this.builder.with("state", state);
    }

    public GHDeploymentStatusBuilder description(String description) {
        this.builder.with("description", description);
        return this;
    }

    public GHDeploymentStatusBuilder targetUrl(String targetUrl) {
        this.builder.with("target_url", targetUrl);
        return this;
    }

    public GHDeploymentStatus create() throws IOException {
        return ((GHDeploymentStatus)((Object)this.builder.to(this.repo.getApiTailUrl("deployments/" + this.deploymentId + "/statuses"), GHDeploymentStatus.class))).wrap(this.repo);
    }
}

