/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.admin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="migration-report-instance")
public class MigrationReportInstance {
    @XmlElement(name="migration-successful")
    private boolean successful;
    @XmlElement(name="migration-start")
    private Date startDate;
    @XmlElement(name="migration-end")
    private Date endDate;
    @XmlElement(name="migration-logs")
    private List<String> logs;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public List<String> getLogs() {
        if (this.logs == null) {
            this.logs = new ArrayList<String>();
        }
        return this.logs;
    }

    public void setLogs(List<String> logs) {
        this.logs = logs;
    }

    public String toString() {
        return "MigrationReportInstance{successful=" + this.successful + ", startDate=" + this.startDate + ", endDate=" + this.endDate + '}';
    }

    public static class Builder {
        private MigrationReportInstance reportInstance = new MigrationReportInstance();

        public MigrationReportInstance build() {
            return this.reportInstance;
        }

        public Builder successful(boolean successful) {
            this.reportInstance.setSuccessful(successful);
            return this;
        }

        public Builder startDate(Date startDate) {
            this.reportInstance.setStartDate(startDate);
            return this;
        }

        public Builder endDate(Date endDate) {
            this.reportInstance.setEndDate(endDate);
            return this;
        }

        public Builder logs(List<String> logs) {
            this.reportInstance.setLogs(logs);
            return this;
        }

        public Builder addLog(String log) {
            this.reportInstance.getLogs().add(log);
            return this;
        }
    }
}

