/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.autoconfiguration;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.servlet.Servlet;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.remote.rest.common.resource.KieServerRestImpl;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerContainerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.springboot.SpringBootKieServerImpl;
import org.kie.server.springboot.autoconfiguration.KieServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={KieServerImpl.class})
@EnableConfigurationProperties(value={KieServerProperties.class})
public class KieServerAutoConfiguration
extends ResourceConfig {
    private static final Logger logger = LoggerFactory.getLogger(KieServerAutoConfiguration.class);
    private KieServerProperties properties;
    private IdentityProvider identityProvider;

    public KieServerAutoConfiguration(KieServerProperties properties, Optional<IdentityProvider> identityProvider) {
        this.properties = properties;
        if (identityProvider.isPresent()) {
            this.identityProvider = identityProvider.get();
        }
    }

    @Bean
    @ConditionalOnMissingBean(name={"kieServerExtension"})
    public KieServerExtension kieServerExtension() {
        return new KieServerContainerExtension();
    }

    @Bean(destroyMethod="destroy")
    @ConditionalOnMissingBean(name={"kieServer"})
    public KieServer kieServer(List<KieServerExtension> extensions) {
        System.setProperty("org.kie.server.controller", this.properties.getControllers());
        System.setProperty("org.kie.server.location", this.properties.getLocation());
        if (KieServerEnvironment.getServerId() == null) {
            String serverName = this.properties.getServerName();
            String serverId = this.properties.getServerId();
            KieServerEnvironment.setServerId((String)serverId.toString());
            KieServerEnvironment.setServerName((String)serverName);
        }
        logger.info("KieServer (id {} (name {})) started initialization process", (Object)KieServerEnvironment.getServerId(), (Object)KieServerEnvironment.getServerName());
        SpringBootKieServerImpl kieServer = new SpringBootKieServerImpl(extensions, this.identityProvider);
        kieServer.init();
        KieServerRestImpl kieServerResource = new KieServerRestImpl((KieServerImpl)kieServer);
        this.registerInstances(new Object[]{kieServerResource});
        List activeExtensions = kieServer.getServerExtensions();
        for (KieServerExtension extension : activeExtensions) {
            LinkedHashSet resources = new LinkedHashSet(extension.getAppComponents(SupportedTransports.REST));
            this.registerInstances(resources);
        }
        logger.info("KieServer (id {}) started successfully", (Object)KieServerEnvironment.getServerId());
        return kieServer;
    }

    @Bean
    public ServletRegistrationBean jerseyServlet() {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new ServletContainer(), new String[]{this.properties.getRestContextPath() + "/*"});
        registration.addInitParameter("javax.ws.rs.Application", KieServerAutoConfiguration.class.getName());
        return registration;
    }
}

