/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.DefaultAttributes;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;

public class LegacyAttributes
extends DefaultAttributes {
    public LegacyAttributes(UserProfileContext context, Map<String, ?> attributes, UserModel user, UserProfileMetadata profileMetadata, KeycloakSession session) {
        super(context, attributes, user, profileMetadata, session);
    }

    protected boolean isSupportedAttribute(String name) {
        if (UserProfileContext.USER_API.equals((Object)this.context) || UserProfileContext.ACCOUNT.equals((Object)this.context)) {
            return true;
        }
        if (super.isSupportedAttribute(name)) {
            return true;
        }
        return name.startsWith("user.attributes.");
    }

    public boolean isReadOnly(String name) {
        RealmModel realm = this.session.getContext().getRealm();
        if (this.isReadOnlyInternalAttribute(name)) {
            return true;
        }
        if (this.user == null) {
            return false;
        }
        if ("username".equals(name)) {
            if (this.isServiceAccountUser()) {
                return true;
            }
            if (UserProfileContext.IDP_REVIEW.equals((Object)this.context)) {
                return false;
            }
            if (realm.isRegistrationEmailAsUsername()) {
                return true;
            }
            return !realm.isEditUsernameAllowed();
        }
        if ("email".equals(name)) {
            if (this.isServiceAccountUser()) {
                return false;
            }
            if (UserProfileContext.IDP_REVIEW.equals((Object)this.context) || UserProfileContext.USER_API.equals((Object)this.context)) {
                return false;
            }
            if (realm.isRegistrationEmailAsUsername() && !realm.isEditUsernameAllowed()) {
                return true;
            }
        }
        return false;
    }

    public Map<String, List<String>> getReadable() {
        if (this.user == null || this.user.getAttributes() == null) {
            return super.getReadable();
        }
        return new HashMap<String, List<String>>(this.user.getAttributes());
    }

    public Map<String, List<String>> getWritable() {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>((Map<String, List<String>>)((Object)this));
        RealmModel realm = this.session.getContext().getRealm();
        for (String name : this.nameSet()) {
            if (!this.isReadOnly(name) || "username".equals(name) && realm.isRegistrationEmailAsUsername()) continue;
            attributes.remove(name);
        }
        return attributes;
    }

    protected boolean isIncludeAttributeIfNotProvided(AttributeMetadata metadata) {
        if ("locale".equals(metadata.getName())) {
            return false;
        }
        return UserProfileContext.USER_API.equals((Object)this.context);
    }
}

