/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.List;
import javax.ws.rs.core.Response;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class EmailExistsAsUsernameValidator
implements SimpleValidator {
    public static final String ID = "up-email-exists-as-username";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        List values = (List)input;
        if (values == null || values.isEmpty()) {
            return context;
        }
        String value = (String)values.get(0);
        if (Validation.isBlank(value)) {
            return context;
        }
        KeycloakSession session = context.getSession();
        RealmModel realm = session.getContext().getRealm();
        if (!realm.isDuplicateEmailsAllowed() && realm.isRegistrationEmailAsUsername()) {
            UserModel user = UserProfileAttributeValidationContext.from((ValidationContext)context).getAttributeContext().getUser();
            UserModel userByEmail = session.users().getUserByEmail(realm, value);
            if (userByEmail != null && user != null && !userByEmail.getId().equals(user.getId())) {
                context.addError(new ValidationError(ID, inputHint, "usernameExistsMessage").setStatusCode(Response.Status.CONFLICT));
            }
        }
        return context;
    }
}

