/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.FapiConstant;

public class SecureSigningAlgorithmForSignedJwtExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(SecureSigningAlgorithmForSignedJwtExecutor.class);
    private final KeycloakSession session;
    private Configuration configuration;

    public SecureSigningAlgorithmForSignedJwtExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "secure-signature-algorithm-signed-jwt";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case TOKEN_REQUEST: 
            case SERVICE_ACCOUNT_TOKEN_REQUEST: 
            case TOKEN_REFRESH: 
            case TOKEN_REVOKE: 
            case TOKEN_INTROSPECT: 
            case LOGOUT_REQUEST: {
                boolean isRequireClientAssertion = Optional.ofNullable(this.configuration.isRequireClientAssertion()).orElse(Boolean.FALSE);
                HttpRequest req = (HttpRequest)this.session.getContext().getContextObject(HttpRequest.class);
                String clientAssertion = (String)req.getDecodedFormParameters().getFirst((Object)"client_assertion");
                if (!isRequireClientAssertion && ObjectUtil.isBlank((CharSequence)clientAssertion)) break;
                JWSInput jws = null;
                try {
                    jws = new JWSInput(clientAssertion);
                }
                catch (JWSInputException e) {
                    throw new ClientPolicyException("invalid_request", "not allowed input format.");
                }
                this.verifySecureSigningAlgorithm(jws.getHeader().getAlgorithm().name());
                break;
            }
            default: {
                return;
            }
        }
    }

    private void verifySecureSigningAlgorithm(String signatureAlgorithm) throws ClientPolicyException {
        if (FapiConstant.ALLOWED_ALGORITHMS.contains(signatureAlgorithm)) {
            logger.tracev("Passed. signatureAlgorithm = {0}", (Object)signatureAlgorithm);
            return;
        }
        logger.tracev("NOT allowed signatureAlgorithm = {0}", (Object)signatureAlgorithm);
        throw new ClientPolicyException("invalid_request", "not allowed signature algorithm.");
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="require-client-assertion")
        protected Boolean requireClientAssertion;

        public Boolean isRequireClientAssertion() {
            return this.requireClientAssertion;
        }

        public void setRequireClientAssertion(Boolean requireClientAssertion) {
            this.requireClientAssertion = requireClientAssertion;
        }
    }
}

