/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamWriter;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SSODescriptorType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLMetadataWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IDPMetadataDescriptor {
    public static String getIDPDescriptor(URI loginPostEndpoint, URI loginRedirectEndpoint, URI logoutEndpoint, URI artifactResolutionService, String entityId, boolean wantAuthnRequestsSigned, List<Element> signingCerts) throws ProcessingException {
        StringWriter sw = new StringWriter();
        XMLStreamWriter writer = StaxUtil.getXMLStreamWriter((Writer)sw);
        SAMLMetadataWriter metadataWriter = new SAMLMetadataWriter(writer);
        EntityDescriptorType entityDescriptor = new EntityDescriptorType(entityId);
        IDPSSODescriptorType spIDPDescriptor = new IDPSSODescriptorType(Arrays.asList(JBossSAMLURIConstants.PROTOCOL_NSURI.get()));
        spIDPDescriptor.setWantAuthnRequestsSigned(Boolean.valueOf(wantAuthnRequestsSigned));
        spIDPDescriptor.addNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
        spIDPDescriptor.addNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get());
        spIDPDescriptor.addNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get());
        spIDPDescriptor.addNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get());
        spIDPDescriptor.addSingleLogoutService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri(), logoutEndpoint));
        spIDPDescriptor.addSingleLogoutService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri(), logoutEndpoint));
        spIDPDescriptor.addSingleLogoutService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri(), logoutEndpoint));
        spIDPDescriptor.addSingleSignOnService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri(), loginPostEndpoint));
        spIDPDescriptor.addSingleSignOnService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri(), loginRedirectEndpoint));
        spIDPDescriptor.addSingleSignOnService(new EndpointType(JBossSAMLURIConstants.SAML_SOAP_BINDING.getUri(), loginPostEndpoint));
        spIDPDescriptor.addSingleSignOnService(new EndpointType(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.getUri(), loginPostEndpoint));
        spIDPDescriptor.addArtifactResolutionService(new IndexedEndpointType(JBossSAMLURIConstants.SAML_SOAP_BINDING.getUri(), artifactResolutionService));
        if (wantAuthnRequestsSigned && signingCerts != null) {
            for (Element key : signingCerts) {
                KeyDescriptorType keyDescriptor = new KeyDescriptorType();
                keyDescriptor.setUse(KeyTypes.SIGNING);
                keyDescriptor.setKeyInfo(key);
                spIDPDescriptor.addKeyDescriptor(keyDescriptor);
            }
        }
        entityDescriptor.addChoiceType(new EntityDescriptorType.EDTChoiceType(Arrays.asList(new EntityDescriptorType.EDTDescriptorChoiceType((SSODescriptorType)spIDPDescriptor))));
        metadataWriter.writeEntityDescriptor(entityDescriptor);
        return sw.toString();
    }

    public static Element buildKeyInfoElement(String keyName, String pemEncodedCertificate) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element keyInfo = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:KeyInfo");
        if (keyName != null) {
            Element keyNameElement = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:KeyName");
            keyNameElement.setTextContent(keyName);
            keyInfo.appendChild(keyNameElement);
        }
        Element x509Data = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:X509Data");
        Element x509Certificate = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:X509Certificate");
        x509Certificate.setTextContent(pemEncodedCertificate);
        x509Data.appendChild(x509Certificate);
        keyInfo.appendChild(x509Data);
        return keyInfo;
    }
}

