/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.mysql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.utility.DockerImageName;

public class MySQLDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(MySQLDevServicesProcessor.class);
    public static final String TAG = "8.0.24";
    public static final String MY_CNF_CONFIG_OVERRIDE_PARAM_NAME = "TC_MY_CNF";

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupMysql(final List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem) {
        return new DevServicesDatasourceProviderBuildItem("mysql", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, Optional<String> imageName, Map<String, String> containerProperties, Map<String, String> additionalJdbcUrlProperties, OptionalInt fixedExposedPort, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                final QuarkusMySQLContainer container = new QuarkusMySQLContainer(imageName, fixedExposedPort, !devServicesSharedNetworkBuildItem.isEmpty());
                startupTimeout.ifPresent(arg_0 -> ((QuarkusMySQLContainer)container).withStartupTimeout(arg_0));
                container.withPassword(password.orElse("quarkus")).withUsername(username.orElse("quarkus")).withDatabaseName(datasourceName.orElse("default"));
                if (containerProperties.containsKey(MySQLDevServicesProcessor.MY_CNF_CONFIG_OVERRIDE_PARAM_NAME)) {
                    container.withConfigurationOverride(containerProperties.get(MySQLDevServicesProcessor.MY_CNF_CONFIG_OVERRIDE_PARAM_NAME));
                }
                additionalJdbcUrlProperties.forEach((arg_0, arg_1) -> ((QuarkusMySQLContainer)container).withUrlParam(arg_0, arg_1));
                container.start();
                LOG.info((Object)"Dev Services for MySQL started.");
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getEffectiveJdbcUrl(), container.getUsername(), container.getPassword(), new Closeable(){

                    @Override
                    public void close() throws IOException {
                        container.stop();
                        LOG.info((Object)"Dev Services for MySQL shut down.");
                    }
                });
            }
        });
    }

    private static class QuarkusMySQLContainer
    extends MySQLContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusMySQLContainer(Optional<String> imageName, OptionalInt fixedExposedPort, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElse("docker.io/" + MySQLContainer.IMAGE + ":8.0.24")).asCompatibleSubstituteFor(DockerImageName.parse((String)MySQLContainer.IMAGE)));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"mssql");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), MySQLContainer.MYSQL_PORT);
            } else {
                this.addExposedPort(MYSQL_PORT);
            }
        }

        public String getEffectiveJdbcUrl() {
            if (this.useSharedNetwork) {
                String additionalUrlParams = this.constructUrlParameters("?", "&");
                return "jdbc:mysql://" + this.hostName + ":" + MYSQL_PORT + "/" + this.getDatabaseName() + additionalUrlParams;
            }
            return super.getJdbcUrl();
        }
    }
}

