/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.logging.Level;
import org.jboss.logmanager.LogContext;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.configuration.mappers.ConfigCategory;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;

final class LoggingPropertyMappers {
    private static final String DEFAULT_LOG_LEVEL = "info";

    private LoggingPropertyMappers() {
    }

    public static PropertyMapper[] getMappers() {
        return new PropertyMapper[]{LoggingPropertyMappers.builder().from("log-level").to("quarkus.log.level").transformer(new BiFunction<String, ConfigSourceInterceptorContext, String>(){

            @Override
            public String apply(String value, ConfigSourceInterceptorContext configSourceInterceptorContext) {
                String rootLevel = LoggingPropertyMappers.DEFAULT_LOG_LEVEL;
                for (String level : value.split(",")) {
                    Level levelType;
                    String categoryLevel;
                    String[] parts = level.split(":");
                    String category = null;
                    if (parts.length == 1) {
                        categoryLevel = parts[0];
                    } else if (parts.length == 2) {
                        category = parts[0];
                        categoryLevel = parts[1];
                    } else {
                        QuarkusPlatform.addInitializationException(Messages.invalidLogCategoryFormat(level));
                        return rootLevel;
                    }
                    try {
                        levelType = LoggingPropertyMappers.toLevel(categoryLevel);
                    }
                    catch (IllegalArgumentException iae) {
                        QuarkusPlatform.addInitializationException(Messages.invalidLogLevel(categoryLevel));
                        return rootLevel;
                    }
                    if (category == null) {
                        rootLevel = levelType.getName();
                        continue;
                    }
                    LoggingPropertyMappers.setCategoryLevel(category, levelType.getName());
                }
                return rootLevel;
            }
        }).defaultValue(DEFAULT_LOG_LEVEL).description("The log level of the root category or a comma-separated list of individual categories and their levels. For the root category, you don't need to specify a category.").paramLabel("category:level").build(), LoggingPropertyMappers.builder().from("log-format").to("quarkus.log.console.format").defaultValue("%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n").description("The format of log entries. If the format has spaces in it, you need to escape the value such as \"<format>\".").paramLabel("format").build()};
    }

    private static Level toLevel(String categoryLevel) throws IllegalArgumentException {
        return LogContext.getLogContext().getLevelForName(categoryLevel.toUpperCase(Locale.ROOT));
    }

    private static void setCategoryLevel(String category, String level) {
        LogContext.getLogContext().getLogger(category).setLevel(LoggingPropertyMappers.toLevel(level));
    }

    private static PropertyMapper.Builder builder() {
        return PropertyMapper.builder(ConfigCategory.LOGGING);
    }
}

