/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.common.Profile;
import org.keycloak.quarkus.runtime.configuration.mappers.ConfigCategory;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

final class FeaturePropertyMappers {
    private FeaturePropertyMappers() {
    }

    public static PropertyMapper[] getMappers() {
        return new PropertyMapper[]{FeaturePropertyMappers.builder().from("features").description("Enables a set of one or more features.").expectedValues(FeaturePropertyMappers.getFeatureValues()).paramLabel("feature").build(), FeaturePropertyMappers.builder().from("features-disabled").expectedValues(FeaturePropertyMappers.getFeatureValues()).paramLabel("feature").description("Disables a set of one or more features.").build()};
    }

    private static List<String> getFeatureValues() {
        ArrayList<String> features = new ArrayList<String>();
        for (Profile.Feature value : Profile.Feature.values()) {
            features.add(value.name().toLowerCase().replace('_', '-'));
        }
        features.add(Profile.Type.PREVIEW.name().toLowerCase());
        return features;
    }

    private static PropertyMapper.Builder builder() {
        return PropertyMapper.builder(ConfigCategory.FEATURE).isBuildTimeProperty(true);
    }
}

