/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;

public final class QuarkusPropertiesConfigSource
extends AbstractLocationConfigSourceLoader
implements ConfigSourceProvider {
    private static final String NAME = "QuarkusProperties";
    private static final String FILE_NAME = "quarkus.properties";
    public static final String QUARKUS_PROPERTY_ENABLED = "kc.quarkus-properties-enabled";

    public static boolean isSameSource(ConfigValue value) {
        if (value == null) {
            return false;
        }
        return NAME.equals(value.getConfigSourceName());
    }

    public static boolean isQuarkusPropertiesEnabled() {
        return Boolean.parseBoolean(Configuration.getRawPersistedProperty(QUARKUS_PROPERTY_ENABLED).orElse(Boolean.FALSE.toString()));
    }

    public static Path getConfigurationFile() {
        File file;
        String homeDir = Environment.getHomeDir();
        if (homeDir != null && (file = Paths.get(homeDir, "conf", FILE_NAME).toFile()).exists()) {
            return file.toPath();
        }
        return null;
    }

    protected String[] getFileExtensions() {
        return new String[]{"properties"};
    }

    protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
        return new PropertiesConfigSource(ConfigSourceUtil.urlToMap((URL)url), FILE_NAME, ordinal){

            public String getName() {
                return QuarkusPropertiesConfigSource.NAME;
            }

            public String getValue(String propertyName) {
                if (propertyName.startsWith("quarkus")) {
                    String value = super.getValue(propertyName);
                    if (value == null) {
                        return PersistedConfigSource.getInstance().getValue(propertyName);
                    }
                    return value;
                }
                return null;
            }
        };
    }

    public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
        Path configFile;
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        configSources.addAll(this.loadConfigSources("META-INF/services/quarkus.properties", 450, classLoader));
        if ((Environment.isRebuild().booleanValue() || Environment.isRebuildCheck()) && (configFile = QuarkusPropertiesConfigSource.getConfigurationFile()) != null) {
            configSources.addAll(this.loadConfigSources(configFile.toUri().toString(), 500, classLoader));
        }
        return configSources;
    }

    protected List<ConfigSource> tryClassPath(URI uri, int ordinal, ClassLoader classLoader) {
        try {
            return super.tryClassPath(uri, ordinal, classLoader);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchFileException) {
                return Collections.emptyList();
            }
            throw e;
        }
    }
}

