/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.keycloak.Config;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class MicroProfileConfigProvider
implements Config.ConfigProvider {
    public static final String NS_KEYCLOAK = "kc";
    public static final String NS_KEYCLOAK_PREFIX = "kc.";
    public static final String NS_QUARKUS = "quarkus";
    public static final String NS_QUARKUS_PREFIX = "quarkus.";
    private final Config config;

    public MicroProfileConfigProvider() {
        this(ConfigProvider.getConfig());
    }

    public MicroProfileConfigProvider(Config config) {
        this.config = config;
    }

    public String getProvider(String spi) {
        return this.scope(spi).get("provider");
    }

    public Config.Scope scope(String ... scope) {
        return new MicroProfileScope(scope);
    }

    private static String toDashCase(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        boolean l = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (l && Character.isUpperCase(c)) {
                sb.append('-');
                c = Character.toLowerCase(c);
                l = false;
            } else {
                l = Character.isLowerCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public class MicroProfileScope
    implements Config.Scope {
        private final String[] scope;
        private final String prefix;

        public MicroProfileScope(String ... scope) {
            this.scope = scope;
            this.prefix = MicroProfileConfigProvider.NS_KEYCLOAK_PREFIX + String.join((CharSequence)Configuration.OPTION_PART_SEPARATOR, (CharSequence[])ArrayUtils.insert((int)0, (Object[])scope, (Object[])new String[]{"spi"}));
        }

        public String get(String key) {
            return this.getValue(key, String.class, null);
        }

        public String get(String key, String defaultValue) {
            return this.getValue(key, String.class, defaultValue);
        }

        public String[] getArray(String key) {
            return this.getValue(key, String[].class, null);
        }

        public Integer getInt(String key) {
            return this.getValue(key, Integer.class, null);
        }

        public Integer getInt(String key, Integer defaultValue) {
            return this.getValue(key, Integer.class, defaultValue);
        }

        public Long getLong(String key) {
            return this.getValue(key, Long.class, null);
        }

        public Long getLong(String key, Long defaultValue) {
            return this.getValue(key, Long.class, defaultValue);
        }

        public Boolean getBoolean(String key) {
            return this.getValue(key, Boolean.class, null);
        }

        public Boolean getBoolean(String key, Boolean defaultValue) {
            return this.getValue(key, Boolean.class, defaultValue);
        }

        public Config.Scope scope(String ... scope) {
            return new MicroProfileScope((String[])ArrayUtils.addAll((Object[])this.scope, (Object[])scope));
        }

        public Set<String> getPropertyNames() {
            return StreamSupport.stream(MicroProfileConfigProvider.this.config.getPropertyNames().spliterator(), false).filter(new Predicate<String>(){

                @Override
                public boolean test(String key) {
                    return key.startsWith(MicroProfileScope.this.prefix) || key.startsWith(Configuration.toEnvVarFormat(MicroProfileScope.this.prefix));
                }
            }).collect(Collectors.toSet());
        }

        private <T> T getValue(String key, Class<T> clazz, T defaultValue) {
            return MicroProfileConfigProvider.this.config.getOptionalValue(MicroProfileConfigProvider.toDashCase(this.prefix.concat(Configuration.OPTION_PART_SEPARATOR).concat(key)), clazz).orElse(defaultValue);
        }
    }
}

