/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.util.List;
import java.util.Optional;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.command.AbstractStartCommand;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import picocli.CommandLine;

@CommandLine.Command(name="start", header={"Start the server."}, description={"%nUse this command to run the server in production."}, footer={"%nYou may use the \"--auto-build\" option when starting the server to avoid running the \"build\" command everytime you need to change a static property:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --auto-build <OPTIONS>%n%nBy doing that you have an additional overhead when the server is starting. Run \"${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} build -h\" for more details."})
public final class Start
extends AbstractStartCommand
implements Runnable {
    public static final String NAME = "start";
    @CommandLine.Option(names={"-b", "--auto-build"}, description={"Automatically detects whether the server configuration changed and a new server image must be built prior to starting the server. This option provides an alternative to manually running the 'build' prior to starting the server. Use this configuration carefully in production as it might impact the startup time."}, paramLabel="none", order=1)
    Boolean autoConfig;

    @Override
    protected void doBeforeRun() {
        this.devProfileNotAllowedError();
    }

    private void devProfileNotAllowedError() {
        if (Start.isDevProfileNotAllowed(this.spec.commandLine().getParseResult().expandedArgs())) {
            this.executionError(this.spec.commandLine(), Messages.devProfileNotAllowedError(NAME));
        }
    }

    public static boolean isDevProfileNotAllowed(List<String> currentCliArgs) {
        Optional<String> currentProfile = Optional.ofNullable(Environment.getProfile());
        Optional<String> persistedProfile = Configuration.getRawPersistedProperty("kc.profile");
        Environment.setProfile(currentProfile.orElse(persistedProfile.orElse("prod")));
        return Environment.isDevProfile() && (!currentCliArgs.contains("--auto-build") || !currentCliArgs.contains("-b"));
    }
}

