/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.metrics.runtime.SmallRyeMetricsHandler;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.servicelocator.ServiceLocator;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.jboss.marshalling.core.JBossUserMarshaller;
import org.infinispan.manager.DefaultCacheManager;
import org.keycloak.common.Profile;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.Spi;
import org.keycloak.quarkus.runtime.QuarkusProfile;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.integration.QuarkusKeycloakSessionFactory;
import org.keycloak.quarkus.runtime.storage.database.liquibase.FastServiceLocator;
import org.keycloak.quarkus.runtime.storage.infinispan.CacheManagerFactory;

@Recorder
public class KeycloakRecorder {
    public void configureLiquibase(Map<String, List<String>> services) {
        ServiceLocator locator = Scope.getCurrentScope().getServiceLocator();
        if (locator instanceof FastServiceLocator) {
            ((FastServiceLocator)locator).initServices(services);
        }
    }

    public void configSessionFactory(Map<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories, Map<Class<? extends Provider>, String> defaultProviders, Map<String, ProviderFactory> preConfiguredProviders, Boolean reaugmented) {
        Profile.setInstance((Profile)new QuarkusProfile());
        QuarkusKeycloakSessionFactory.setInstance(new QuarkusKeycloakSessionFactory(factories, defaultProviders, preConfiguredProviders, reaugmented));
    }

    public RuntimeValue<CacheManagerFactory> createCacheInitializer(String config, ShutdownContext shutdownContext) {
        try {
            ConfigurationBuilderHolder builder = new ParserRegistry().parse(config);
            if (((ConfigurationBuilder)builder.getNamedConfigurationBuilders().get("sessions")).clustering().cacheMode().isClustered()) {
                this.configureTransportStack(builder);
            }
            builder.getGlobalConfigurationBuilder().serialization().marshaller((Marshaller)new JBossUserMarshaller());
            final CacheManagerFactory cacheManagerFactory = new CacheManagerFactory(builder);
            shutdownContext.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    DefaultCacheManager cacheManager = cacheManagerFactory.getOrCreate();
                    if (cacheManager != null) {
                        cacheManager.stop();
                    }
                }
            });
            return new RuntimeValue((Object)cacheManagerFactory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void configureTransportStack(ConfigurationBuilderHolder builder) {
        String transportStack = Configuration.getRawValue("kc.cache-stack");
        if (transportStack != null) {
            builder.getGlobalConfigurationBuilder().transport().defaultTransport().addProperty("configurationFile", (Object)("default-configs/default-jgroups-" + transportStack + ".xml"));
        }
    }

    public void registerShutdownHook(ShutdownContext shutdownContext) {
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusKeycloakSessionFactory.getInstance().close();
            }
        });
    }

    public Handler<RoutingContext> createMetricsHandler(String path) {
        SmallRyeMetricsHandler metricsHandler = new SmallRyeMetricsHandler();
        metricsHandler.setMetricsPath(path);
        return metricsHandler;
    }
}

