/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.annotations.QuarkusMain;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.command.Start;

@QuarkusMain(name="keycloak")
@ApplicationScoped
public class KeycloakMain
implements QuarkusApplication {
    private static final Logger LOGGER = Logger.getLogger(KeycloakMain.class);

    public static void main(String[] args) {
        System.setProperty("kc.version", Version.VERSION_KEYCLOAK);
        List<String> cliArgs = Picocli.parseArgs(args);
        if (cliArgs.isEmpty()) {
            cliArgs = new ArrayList<String>(cliArgs);
            cliArgs.add("-h");
        } else if (cliArgs.contains("start") && cliArgs.size() == 1) {
            ExecutionExceptionHandler errorHandler = new ExecutionExceptionHandler();
            PrintWriter errStream = new PrintWriter(System.err, true);
            if (Start.isDevProfileNotAllowed(Arrays.asList(args))) {
                errorHandler.error(errStream, Messages.devProfileNotAllowedError("start"), null);
                return;
            }
            KeycloakMain.start(errorHandler, errStream);
            return;
        }
        Picocli.parseAndRun(cliArgs);
    }

    public static void start(ExecutionExceptionHandler errorHandler, PrintWriter errStream) {
        try {
            Quarkus.run(KeycloakMain.class, (exitCode, cause) -> {
                if (cause != null) {
                    errorHandler.error(errStream, String.format("Failed to start server in (%s) mode", Environment.getKeycloakModeFromProfile(Environment.getProfileOrDefault("prod"))), cause.getCause());
                }
                if (Environment.isDistribution()) {
                    System.exit(exitCode);
                }
            }, (String[])new String[0]);
        }
        catch (Throwable cause2) {
            errorHandler.error(errStream, String.format("Unexpected error when starting the server in (%s) mode", Environment.getKeycloakModeFromProfile(Environment.getProfileOrDefault("prod"))), cause2.getCause());
        }
    }

    public int run(String ... args) throws Exception {
        if (Environment.isDevProfile()) {
            LOGGER.warnf("Running the server in development mode. DO NOT use this configuration in production.", new Object[0]);
        }
        int exitCode = ApplicationLifecycleManager.getExitCode();
        if (Environment.isTestLaunchMode()) {
            Quarkus.asyncExit((int)exitCode);
        } else {
            Quarkus.waitForExit();
        }
        return exitCode;
    }
}

