/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.ExpressionNode;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.LineSeparatorNode;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ParameterDeclarationNode;
import io.quarkus.qute.ParserHelper;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateImpl;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.TextNode;
import io.quarkus.qute.Variant;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class Parser
implements Function<String, Expression>,
ParserHelper {
    private static final Logger LOGGER = Logger.getLogger(Parser.class);
    private static final String ROOT_HELPER_NAME = "$root";
    static final TemplateNode.Origin SYNTHETIC_ORIGIN = new OriginImpl(0, 0, 0, "<<synthetic>>", "<<synthetic>>", Optional.empty());
    private static final char START_DELIMITER = '{';
    private static final char END_DELIMITER = '}';
    private static final char COMMENT_DELIMITER = '!';
    private static final char CDATA_START_DELIMITER = '|';
    private static final char CDATA_START_DELIMITER_OLD = '[';
    private static final char CDATA_END_DELIMITER = '|';
    private static final char CDATA_END_DELIMITER_OLD = ']';
    private static final char UNDERSCORE = '_';
    private static final char ESCAPE_CHAR = '\\';
    private static final char NAMESPACE_SEPARATOR = ':';
    private static final char LINE_SEPARATOR_LF = '\n';
    private static final char LINE_SEPARATOR_CR = '\r';
    static final char START_COMPOSITE_PARAM = '(';
    static final char END_COMPOSITE_PARAM = ')';
    private final EngineImpl engine;
    private final Reader reader;
    private final Optional<Variant> variant;
    private final String templateId;
    private final String generatedId;
    private StringBuilder buffer;
    private State state;
    private int line;
    private int lineCharacter;
    private final Deque<SectionNode.Builder> sectionStack;
    private final Deque<SectionHelperFactory.ParametersInfo> paramsStack;
    private final Deque<Scope> scopeStack;
    private int sectionBlockIdx;
    private boolean ignoreContent;
    private AtomicInteger expressionIdGenerator;
    private final List<Function<String, String>> contentFilters;
    private boolean hasLineSeparator;
    private static final SectionHelper ROOT_SECTION_HELPER = new SectionHelper(){

        @Override
        public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
            return context.execute();
        }
    };
    private static final SectionHelperFactory<SectionHelper> ROOT_SECTION_HELPER_FACTORY = new SectionHelperFactory<SectionHelper>(){

        @Override
        public SectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return ROOT_SECTION_HELPER;
        }
    };
    private static final BlockNode BLOCK_NODE = new BlockNode();
    static final CommentNode COMMENT_NODE = new CommentNode();

    public Parser(EngineImpl engine, Reader reader, String templateId, String generatedId, Optional<Variant> variant) {
        this.engine = engine;
        this.templateId = templateId;
        this.generatedId = generatedId;
        this.variant = variant;
        this.reader = reader;
        this.state = State.TEXT;
        this.buffer = new StringBuilder();
        this.sectionStack = new ArrayDeque<SectionNode.Builder>();
        this.sectionBlockIdx = 0;
        this.paramsStack = new ArrayDeque<SectionHelperFactory.ParametersInfo>();
        this.paramsStack.addFirst(SectionHelperFactory.ParametersInfo.EMPTY);
        this.scopeStack = new ArrayDeque<Scope>();
        this.scopeStack.addFirst(new Scope(null));
        this.line = 1;
        this.lineCharacter = 1;
        this.expressionIdGenerator = new AtomicInteger();
        this.contentFilters = new ArrayList<Function<String, String>>(5);
    }

    Template parse() {
        this.sectionStack.addFirst(SectionNode.builder(ROOT_HELPER_NAME, this.origin(0), this, this::parserError).setEngine(this.engine).setHelperFactory(ROOT_SECTION_HELPER_FACTORY));
        long start = System.nanoTime();
        Reader r = this.reader;
        try {
            SectionNode.Builder root;
            int val;
            if (!this.contentFilters.isEmpty()) {
                String contents = Parser.toString(this.reader);
                for (Function<String, String> filter : this.contentFilters) {
                    contents = filter.apply(contents);
                }
                r = new StringReader(contents);
            }
            while ((val = r.read()) != -1) {
                this.processCharacter((char)val);
                ++this.lineCharacter;
            }
            if (this.buffer.length() > 0) {
                if (this.state == State.TEXT || this.state == State.LINE_SEPARATOR) {
                    this.flushText();
                } else {
                    Object reason = this.state == State.TAG_INSIDE_STRING_LITERAL ? "unterminated string literal" : (this.state == State.TAG_INSIDE ? "unterminated tag" : "unexpected state [" + this.state + "]");
                    throw this.parserError("unexpected non-text buffer at the end of the template - " + (String)reason + ": " + this.buffer);
                }
            }
            if ((root = this.sectionStack.peek()) == null) {
                throw this.parserError("no root section found");
            }
            if (!root.helperName.equals(ROOT_HELPER_NAME)) {
                throw this.parserError("unterminated section [" + root.helperName + "] detected");
            }
            TemplateImpl template = new TemplateImpl(this.engine, root.build(), this.generatedId, this.variant);
            Set<TemplateNode> nodesToRemove = Collections.emptySet();
            if (this.hasLineSeparator && this.engine.removeStandaloneLines) {
                nodesToRemove = new HashSet<TemplateNode>();
                List<List<TemplateNode>> lines = this.readLines(template.root);
                for (List<TemplateNode> line : lines) {
                    if (!this.isStandalone(line)) continue;
                    for (TemplateNode node : line) {
                        if (node instanceof SectionNode) continue;
                        nodesToRemove.add(node);
                    }
                }
                if (nodesToRemove.isEmpty()) {
                    nodesToRemove = Collections.emptySet();
                }
            }
            template.root.optimizeNodes(nodesToRemove);
            LOGGER.tracef("Parsing finished in %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            return template;
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    private void processCharacter(char character) {
        switch (this.state) {
            case TEXT: {
                this.text(character);
                break;
            }
            case ESCAPE: {
                this.escape(character);
                break;
            }
            case TAG_INSIDE: {
                this.tag(character);
                break;
            }
            case TAG_INSIDE_STRING_LITERAL: {
                this.tagStringLiteral(character);
                break;
            }
            case COMMENT: {
                this.comment(character);
                break;
            }
            case CDATA: {
                this.cdata(character);
                break;
            }
            case TAG_CANDIDATE: {
                this.tagCandidate(character);
                break;
            }
            case LINE_SEPARATOR: {
                this.lineSeparator(character);
                break;
            }
            default: {
                throw this.parserError("unknown parsing state: " + this.state);
            }
        }
    }

    private void escape(char character) {
        if (character != '{' && character != '}') {
            this.buffer.append('\\');
        }
        this.buffer.append(character);
        this.state = State.TEXT;
    }

    private void text(char character) {
        if (character == '{') {
            this.state = State.TAG_CANDIDATE;
        } else if (character == '\\') {
            this.state = State.ESCAPE;
        } else if (this.isLineSeparatorStart(character)) {
            this.flushText();
            this.buffer.append(character);
            this.state = State.LINE_SEPARATOR;
        } else {
            this.buffer.append(character);
        }
    }

    private void lineSeparator(char character) {
        if (character == '\n' && this.buffer.length() > 0 && this.buffer.charAt(this.buffer.length() - 1) == '\r') {
            this.buffer.append(character);
            this.flushNextLine();
            this.state = State.TEXT;
        } else {
            this.flushNextLine();
            this.state = State.TEXT;
            this.processCharacter(character);
        }
        this.hasLineSeparator = true;
    }

    private void comment(char character) {
        if (character == '}' && this.buffer.length() > 0 && this.buffer.charAt(this.buffer.length() - 1) == '!') {
            this.state = State.TEXT;
            this.buffer = new StringBuilder();
            if (this.engine.removeStandaloneLines) {
                this.sectionStack.peek().currentBlock().addNode(COMMENT_NODE);
            }
        } else {
            this.buffer.append(character);
        }
    }

    private void cdata(char character) {
        if (character == '}' && this.buffer.length() > 0 && this.isCdataEnd(this.buffer.charAt(this.buffer.length() - 1))) {
            this.state = State.TEXT;
            this.buffer.deleteCharAt(this.buffer.length() - 1);
            this.flushText();
        } else {
            this.buffer.append(character);
        }
    }

    private boolean isCdataEnd(char character) {
        return character == '|' || character == ']';
    }

    private void tag(char character) {
        if (LiteralSupport.isStringLiteralSeparator(character)) {
            this.state = State.TAG_INSIDE_STRING_LITERAL;
            this.buffer.append(character);
        } else if (character == '}') {
            this.flushTag();
        } else {
            this.buffer.append(character);
        }
    }

    private void tagStringLiteral(char character) {
        if (LiteralSupport.isStringLiteralSeparator(character)) {
            this.state = State.TAG_INSIDE;
        }
        this.buffer.append(character);
    }

    private void tagCandidate(char character) {
        if (this.isValidIdentifierStart(character)) {
            this.flushText();
            if (character == '!') {
                this.buffer.append(character);
                this.state = State.COMMENT;
            } else if (character == '|' || character == '[') {
                this.state = State.CDATA;
            } else {
                this.buffer.append(character);
                this.state = State.TAG_INSIDE;
            }
        } else {
            this.buffer.append('{');
            this.state = State.TEXT;
            if ('{' == character) {
                this.buffer.append('{');
            } else {
                this.processCharacter(character);
            }
        }
    }

    private boolean isValidIdentifierStart(char character) {
        return Tag.isCommand(character) || character == '!' || character == '|' || character == '[' || character == '_' || Character.isDigit(character) || Character.isAlphabetic(character);
    }

    static boolean isValidIdentifier(String value) {
        int c;
        int length = value.length();
        for (int offset = 0; offset < length; offset += Character.charCount(c)) {
            c = value.codePointAt(offset);
            if (!Character.isWhitespace(c)) {
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean isLineSeparatorStart(char character) {
        return character == '\r' || character == '\n';
    }

    private void flushText() {
        if (this.buffer.length() > 0 && !this.ignoreContent) {
            SectionBlock.Builder block = this.sectionStack.peek().currentBlock();
            block.addNode(new TextNode(this.buffer.toString(), this.origin(0)));
        }
        this.buffer = new StringBuilder();
    }

    private void flushNextLine() {
        if (this.buffer.length() > 0 && !this.ignoreContent) {
            SectionBlock.Builder block = this.sectionStack.peek().currentBlock();
            block.addNode(new LineSeparatorNode(this.buffer.toString(), this.origin(0)));
        }
        this.buffer = new StringBuilder();
        ++this.line;
        this.lineCharacter = 1;
    }

    private void flushTag() {
        this.state = State.TEXT;
        String content = this.buffer.toString().trim();
        String tag = "{" + content + "}";
        if (content.charAt(0) == Tag.SECTION.command.charValue()) {
            Iterator<String> iter;
            boolean isEmptySection = false;
            if (content.charAt(content.length() - 1) == Tag.SECTION_END.command.charValue()) {
                content = content.substring(0, content.length() - 1);
                isEmptySection = true;
            }
            if (!(iter = Parser.splitSectionParams(content, this::parserError)).hasNext()) {
                throw this.parserError("no helper name declared");
            }
            String sectionName = iter.next();
            sectionName = sectionName.substring(1, sectionName.length());
            SectionNode.Builder lastSection = this.sectionStack.peek();
            if (lastSection != null && lastSection.factory.getBlockLabels().contains(sectionName) || lastSection.factory.treatUnknownSectionsAsBlocks() && !this.engine.getSectionHelperFactories().containsKey(sectionName)) {
                SectionBlock.Builder block = SectionBlock.builder("" + this.sectionBlockIdx++, this, this::parserError).setOrigin(this.origin(0)).setLabel(sectionName);
                lastSection.addBlock(block);
                this.processParams(tag, sectionName, iter, block);
                Scope currentScope = this.scopeStack.peek();
                Scope newScope = lastSection.factory.initializeBlock(currentScope, block);
                this.scopeStack.addFirst(newScope);
            } else {
                SectionHelperFactory<?> factory = this.engine.getSectionHelperFactory(sectionName);
                if (factory == null) {
                    throw this.parserError("no section helper found for " + tag);
                }
                SectionNode.Builder sectionNode = SectionNode.builder(sectionName, this.origin(0), this, this::parserError).setEngine(this.engine).setHelperFactory(factory);
                this.paramsStack.addFirst(factory.getParameters());
                this.processParams(tag, "$main", iter, sectionNode.currentBlock());
                Scope currentScope = this.scopeStack.peek();
                Scope newScope = factory.initializeBlock(currentScope, sectionNode.currentBlock());
                if (isEmptySection) {
                    this.paramsStack.pop();
                    this.sectionStack.peek().currentBlock().addNode(sectionNode.build());
                } else {
                    this.scopeStack.addFirst(newScope);
                    this.sectionStack.addFirst(sectionNode);
                }
            }
        } else if (content.charAt(0) == Tag.SECTION_END.command.charValue()) {
            SectionNode.Builder section = this.sectionStack.peek();
            SectionBlock.Builder block = section.currentBlock();
            String name = content.substring(1, content.length());
            if (block != null && !block.getLabel().equals("$main") && !section.helperName.equals(name)) {
                if (!name.isEmpty() && !block.getLabel().equals(name)) {
                    throw this.parserError("section block end tag [" + name + "] does not match the start tag [" + block.getLabel() + "]");
                }
                section.endBlock();
            } else {
                if (section.helperName.equals(ROOT_HELPER_NAME)) {
                    throw this.parserError("no section start tag found for " + tag);
                }
                if (!name.isEmpty() && !section.helperName.equals(name)) {
                    throw this.parserError("section end tag [" + name + "] does not match the start tag [" + section.helperName + "]");
                }
                section = this.sectionStack.pop();
                this.sectionStack.peek().currentBlock().addNode(section.build());
            }
            this.scopeStack.pop();
        } else if (content.charAt(0) == Tag.PARAM.command.charValue()) {
            Scope currentScope = this.scopeStack.peek();
            String[] parts = content.substring(1).trim().split("[ ]{1,}");
            if (parts.length != 2) {
                throw this.parserError("invalid parameter declaration {" + this.buffer.toString() + "}");
            }
            String value = parts[0];
            String key = parts[1];
            currentScope.putBinding(key, Expressions.typeInfoFrom(value));
            this.sectionStack.peek().currentBlock().addNode(new ParameterDeclarationNode(content, this.origin(0)));
        } else {
            this.sectionStack.peek().currentBlock().addNode(new ExpressionNode(this.apply(content), this.engine, this.origin(content.length() + 1)));
        }
        this.buffer = new StringBuilder();
    }

    private TemplateException parserError(String message) {
        return Parser.parserError(message, this.origin(0));
    }

    static TemplateException parserError(String message, TemplateNode.Origin origin) {
        StringBuilder builder = new StringBuilder("Parser error");
        if (!origin.getTemplateId().equals(origin.getTemplateGeneratedId())) {
            builder.append(" in template [").append(origin.getTemplateId()).append("]");
        }
        builder.append(" on line ").append(origin.getLine()).append(": ").append(message);
        return new TemplateException(origin, builder.toString());
    }

    private void processParams(String tag, String label, Iterator<String> iter, SectionBlock.Builder block) {
        LinkedHashMap<Object, String> params = new LinkedHashMap<Object, String>();
        SectionHelperFactory.ParametersInfo factoryParamsInfo = this.paramsStack.peek();
        List<Parameter> factoryParams = factoryParamsInfo.get(label);
        ArrayList<String> paramValues = new ArrayList<String>();
        while (iter.hasNext()) {
            String val = iter.next().trim();
            if (val.isEmpty()) continue;
            paramValues.add(val);
        }
        int actualSize = paramValues.size();
        if (factoryParamsInfo.isCheckNumberOfParams() && actualSize > factoryParams.size() && LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Too many section params for ").append(tag);
            TemplateNode.Origin origin = this.origin(0);
            if (!origin.getTemplateId().equals(origin.getTemplateGeneratedId())) {
                builder.append(" in template [").append(origin.getTemplateId()).append("]");
            }
            builder.append(" on line ").append(origin.getLine());
            builder.append(String.format("[label=%s, params=%s, factoryParams=%s]", label, paramValues, factoryParams));
            LOGGER.debugf(builder.toString(), new Object[0]);
        }
        Iterator it = paramValues.iterator();
        while (it.hasNext()) {
            String param = (String)it.next();
            int equalsPosition = Parser.getFirstDeterminingEqualsCharPosition(param);
            if (equalsPosition == -1) continue;
            params.put(param.substring(0, equalsPosition), param.substring(equalsPosition + 1, param.length()));
            it.remove();
        }
        Predicate<String> included = params::containsKey;
        if (actualSize < factoryParams.size()) {
            for (String param : paramValues) {
                Parameter found = this.findFactoryParameter(param, factoryParams, included, true);
                if (found == null) continue;
                params.put(found.name, param);
            }
        } else {
            int generatedIdx = 0;
            for (String param : paramValues) {
                Parameter found = this.findFactoryParameter(param, factoryParams, included, false);
                if (found != null) {
                    params.put(found.name, param);
                    continue;
                }
                params.put("" + generatedIdx++, param);
            }
        }
        factoryParams.stream().filter(Parameter::hasDefaultValue).forEach(p -> params.putIfAbsent(p.name, p.defaultValue));
        List undeclaredParams = factoryParams.stream().filter(Predicate.not(Parameter::isOptional)).map(Parameter::getName).filter(Predicate.not(params::containsKey)).collect(Collectors.toList());
        if (!undeclaredParams.isEmpty()) {
            throw this.parserError("mandatory section parameters not declared for " + tag + ": " + undeclaredParams);
        }
        params.forEach(block::addParameter);
    }

    private Parameter findFactoryParameter(String paramValue, List<Parameter> factoryParams, Predicate<String> included, boolean noDefaultValueTakesPrecedence) {
        if (noDefaultValueTakesPrecedence) {
            for (Parameter param : factoryParams) {
                if (!param.accepts(paramValue) || param.hasDefaultValue() || included.test(param.name)) continue;
                return param;
            }
        }
        for (Parameter param : factoryParams) {
            if (!param.accepts(paramValue) || included.test(param.name)) continue;
            return param;
        }
        return null;
    }

    static int getFirstDeterminingEqualsCharPosition(String part) {
        if (!part.isEmpty() && part.charAt(0) == '(') {
            return -1;
        }
        boolean stringLiteral = false;
        for (int i = 0; i < part.length(); ++i) {
            if (LiteralSupport.isStringLiteralSeparator(part.charAt(i))) {
                if (i == 0) {
                    return -1;
                }
                stringLiteral = !stringLiteral;
                continue;
            }
            if (stringLiteral || part.charAt(i) != '=' || i == 0 || i >= part.length() - 1) continue;
            return i;
        }
        return -1;
    }

    static Iterator<String> splitSectionParams(String content, Function<String, RuntimeException> errorFun) {
        boolean stringLiteral = false;
        int composite = 0;
        int brackets = 0;
        boolean space = false;
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == ' ') {
                if (space) continue;
                if (!stringLiteral && composite == 0 && brackets == 0) {
                    if (buffer.length() > 0) {
                        parts.add(buffer.toString());
                        buffer = new StringBuilder();
                    }
                    space = true;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (composite == 0 && LiteralSupport.isStringLiteralSeparator(c)) {
                stringLiteral = !stringLiteral;
            } else if (!stringLiteral && Parser.isCompositeStart(c) && (i == 0 || space || composite > 0 || buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '!')) {
                composite = (short)(composite + 1);
            } else if (!stringLiteral && Parser.isCompositeEnd(c) && composite > 0) {
                composite = (short)(composite - 1);
            } else if (!stringLiteral && Parser.isLeftBracket(c)) {
                brackets = (byte)(brackets + 1);
            } else if (!stringLiteral && Parser.isRightBracket(c) && brackets > 0) {
                brackets = (byte)(brackets - 1);
            }
            space = false;
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            if (stringLiteral || composite > 0) {
                throw errorFun.apply("unterminated string literal or composite parameter detected for [" + content + "]");
            }
            parts.add(buffer.toString());
        }
        return parts.iterator();
    }

    static boolean isCompositeStart(char character) {
        return character == '(';
    }

    static boolean isCompositeEnd(char character) {
        return character == ')';
    }

    static ExpressionImpl parseExpression(Supplier<Integer> idGenerator, String value, Scope scope, TemplateNode.Origin origin) {
        List<String> strParts;
        int bracketIdx;
        int spaceIdx;
        if (value == null || value.isEmpty()) {
            return ExpressionImpl.EMPTY;
        }
        String namespace = null;
        int namespaceIdx = value.indexOf(58);
        if (!(namespaceIdx == -1 || (spaceIdx = value.indexOf(32)) != -1 && namespaceIdx >= spaceIdx || (bracketIdx = value.indexOf(40)) != -1 && namespaceIdx >= bracketIdx || LiteralSupport.isStringLiteralSeparator(value.charAt(0)))) {
            strParts = Expressions.splitParts(value.substring(namespaceIdx + 1, value.length()));
            namespace = value.substring(0, namespaceIdx);
        } else {
            Object literalValue = LiteralSupport.getLiteralValue(value);
            if (!Results.isNotFound(literalValue)) {
                return ExpressionImpl.literal(idGenerator.get(), value, literalValue, origin);
            }
            strParts = Expressions.splitParts(value);
        }
        if (strParts.isEmpty()) {
            throw Parser.parserError("empty expression found {" + value + "}", origin);
        }
        int lastIdx = strParts.size() - 1;
        String last = strParts.get(lastIdx);
        if (last.endsWith("??")) {
            strParts = ImmutableList.builder().addAll(strParts.subList(0, lastIdx)).add(last.substring(0, last.length() - 2)).add("or(null)").build();
        }
        ArrayList<Expression.Part> parts = new ArrayList<Expression.Part>(strParts.size());
        Expression.Part first = null;
        Iterator<String> strPartsIterator = strParts.iterator();
        while (strPartsIterator.hasNext()) {
            Expression.Part part = Parser.createPart(idGenerator, namespace, first, strPartsIterator, scope, origin, value);
            if (!Parser.isValidIdentifier(part.getName())) {
                throw Parser.parserError("invalid identifier found {" + value + "}", origin);
            }
            if (first == null) {
                first = part;
            }
            parts.add(part);
        }
        return new ExpressionImpl(idGenerator.get(), namespace, ImmutableList.copyOf(parts), Results.NotFound.EMPTY, origin);
    }

    private static Expression.Part createPart(Supplier<Integer> idGenerator, String namespace, Expression.Part first, Iterator<String> strPartsIterator, Scope scope, TemplateNode.Origin origin, String exprValue) {
        String value = strPartsIterator.next();
        if (Expressions.isVirtualMethod(value)) {
            String name = Expressions.parseVirtualMethodName(value);
            ArrayList<String> strParams = new ArrayList<String>(Expressions.parseVirtualMethodParams(value, origin, exprValue));
            ArrayList<Expression> params = new ArrayList<Expression>(strParams.size());
            for (String strParam : strParams) {
                params.add(Parser.parseExpression(idGenerator, strParam.trim(), scope, origin));
            }
            String lastPartHint = strPartsIterator.hasNext() ? null : scope.getLastPartHint();
            return new ExpressionImpl.VirtualMethodPartImpl(name, params, lastPartHint);
        }
        if (Expressions.isBracketNotation(value)) {
            Object literal = LiteralSupport.getLiteralValue(value = Expressions.parseBracketContent(value, origin, exprValue));
            if (literal != null && !Results.isNotFound(literal)) {
                value = literal.toString();
            } else {
                StringBuilder builder = new StringBuilder(literal == null ? "Null" : "Non-literal");
                builder.append(" value used in bracket notation [").append(value).append("]");
                if (!origin.getTemplateId().equals(origin.getTemplateGeneratedId())) {
                    builder.append(" in template [").append(origin.getTemplateId()).append("]");
                }
                builder.append(" on line ").append(origin.getLine());
                throw new TemplateException(builder.toString());
            }
        }
        Object typeInfo = null;
        if (namespace != null) {
            typeInfo = first != null ? value : namespace + ":" + value;
        } else if (first == null) {
            typeInfo = scope.getBinding(value);
        } else if (first.getTypeInfo() != null) {
            typeInfo = value;
        }
        if (typeInfo != null && !strPartsIterator.hasNext() && scope.getLastPartHint() != null) {
            typeInfo = (String)typeInfo + scope.getLastPartHint();
        }
        return new ExpressionImpl.PartImpl(value, (String)typeInfo);
    }

    static boolean isLeftBracket(char character) {
        return character == '(';
    }

    static boolean isRightBracket(char character) {
        return character == ')';
    }

    @Override
    public ExpressionImpl apply(String value) {
        return Parser.parseExpression(this.expressionIdGenerator::incrementAndGet, value, this.scopeStack.peek(), this.origin(value.length() + 1));
    }

    TemplateNode.Origin origin(int lineCharacterOffset) {
        return new OriginImpl(this.line, this.lineCharacter - lineCharacterOffset, this.lineCharacter, this.templateId, this.generatedId, this.variant);
    }

    private List<List<TemplateNode>> readLines(SectionNode rootNode) {
        ArrayList<List<TemplateNode>> lines = new ArrayList<List<TemplateNode>>();
        lines.add(this.readLines(lines, null, rootNode));
        return lines;
    }

    private List<TemplateNode> readLines(List<List<TemplateNode>> lines, List<TemplateNode> currentLine, SectionNode sectionNode) {
        boolean isRoot;
        if (currentLine == null) {
            currentLine = new ArrayList<TemplateNode>();
        }
        if (!(isRoot = ROOT_HELPER_NAME.equals(sectionNode.name))) {
            currentLine.add(sectionNode);
        }
        for (SectionBlock block : sectionNode.blocks) {
            if (!isRoot) {
                currentLine.add(BLOCK_NODE);
            }
            for (TemplateNode node : block.nodes) {
                if (node instanceof SectionNode) {
                    currentLine = this.readLines(lines, currentLine, (SectionNode)node);
                    continue;
                }
                if (node instanceof LineSeparatorNode) {
                    currentLine.add(node);
                    lines.add(currentLine);
                    currentLine = new ArrayList<TemplateNode>();
                    continue;
                }
                currentLine.add(node);
            }
            if (isRoot) continue;
            currentLine.add(BLOCK_NODE);
        }
        if (!ROOT_HELPER_NAME.equals(sectionNode.name)) {
            currentLine.add(sectionNode);
        }
        return currentLine;
    }

    private boolean isStandalone(List<TemplateNode> line) {
        boolean maybeStandalone = false;
        for (TemplateNode node : line) {
            if (node instanceof ExpressionNode) {
                return false;
            }
            if (node instanceof SectionNode || node instanceof ParameterDeclarationNode || node == BLOCK_NODE || node == COMMENT_NODE) {
                maybeStandalone = true;
                continue;
            }
            if (!(node instanceof TextNode) || this.isBlank(((TextNode)node).getValue())) continue;
            return false;
        }
        return maybeStandalone;
    }

    private boolean isBlank(CharSequence val) {
        if (val == null) {
            return true;
        }
        int length = val.length();
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(val.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String toString(Reader in) throws IOException {
        if (in instanceof StringReader) {
            return ((StringReader)in).str;
        }
        StringBuilder out = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        while (in.read(buffer) != -1) {
            buffer.flip();
            out.append(buffer);
            buffer.clear();
        }
        return out.toString();
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    @Override
    public void addParameter(String name, String type) {
        Scope currentScope = this.scopeStack.peek();
        currentScope.putBinding(name, Expressions.typeInfoFrom(type));
    }

    @Override
    public void addContentFilter(Function<String, String> filter) {
        this.contentFilters.add(filter);
    }

    static class CommentNode
    implements TemplateNode {
        CommentNode() {
        }

        @Override
        public CompletionStage<ResultNode> resolve(ResolutionContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TemplateNode.Origin getOrigin() {
            throw new UnsupportedOperationException();
        }
    }

    private static class BlockNode
    implements TemplateNode {
        private BlockNode() {
        }

        @Override
        public CompletionStage<ResultNode> resolve(ResolutionContext context) {
            throw new IllegalStateException();
        }

        @Override
        public TemplateNode.Origin getOrigin() {
            throw new IllegalStateException();
        }
    }

    static class OriginImpl
    implements TemplateNode.Origin {
        private final int line;
        private final int lineCharacterStart;
        private final int lineCharacterEnd;
        private final String templateId;
        private final String templateGeneratedId;
        private final Optional<Variant> variant;

        OriginImpl(int line, int lineCharacterStart, int lineCharacterEnd, String templateId, String templateGeneratedId, Optional<Variant> variant) {
            this.line = line;
            this.lineCharacterStart = lineCharacterStart;
            this.lineCharacterEnd = lineCharacterEnd;
            this.templateId = templateId;
            this.templateGeneratedId = templateGeneratedId;
            this.variant = variant;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getLineCharacterStart() {
            return this.lineCharacterStart;
        }

        @Override
        public int getLineCharacterEnd() {
            return this.lineCharacterEnd;
        }

        @Override
        public String getTemplateId() {
            return this.templateId;
        }

        @Override
        public String getTemplateGeneratedId() {
            return this.templateGeneratedId;
        }

        @Override
        public Optional<Variant> getVariant() {
            return this.variant;
        }

        public int hashCode() {
            return Objects.hash(this.line, this.templateGeneratedId, this.templateId, this.variant);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OriginImpl other = (OriginImpl)obj;
            return this.line == other.line && Objects.equals(this.templateGeneratedId, other.templateGeneratedId) && Objects.equals(this.templateId, other.templateId) && Objects.equals(this.variant, other.variant);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Template ").append(this.templateId).append(" at line ").append(this.line);
            return builder.toString();
        }
    }

    static class StringReader
    extends java.io.StringReader {
        final String str;

        public StringReader(String s) {
            super(s);
            this.str = s;
        }
    }

    static enum State {
        TEXT,
        TAG_INSIDE,
        TAG_INSIDE_STRING_LITERAL,
        TAG_CANDIDATE,
        COMMENT,
        ESCAPE,
        CDATA,
        LINE_SEPARATOR;

    }

    static enum Tag {
        EXPRESSION(null),
        SECTION(Character.valueOf('#')),
        SECTION_END(Character.valueOf('/')),
        PARAM(Character.valueOf('@'));

        final Character command;

        private Tag(Character command) {
            this.command = command;
        }

        static boolean isCommand(char command) {
            for (Tag tag : Tag.values()) {
                if (tag.command == null || tag.command.charValue() != command) continue;
                return true;
            }
            return false;
        }
    }

    static class RootSectionHelperFactory
    implements SectionHelperFactory<SectionHelper> {
        RootSectionHelperFactory() {
        }

        @Override
        public SectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return new SectionHelper(){

                @Override
                public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
                    return context.execute();
                }
            };
        }
    }
}

