/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.async;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.flowables.ConnectableFlowable;
import io.reactivex.rxjava3.functions.Function;
import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.reactive.RxJavaInterop;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.async.ClearModification;
import org.infinispan.persistence.async.Modification;
import org.infinispan.persistence.async.PutModification;
import org.infinispan.persistence.async.RemoveModification;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.support.DelegatingNonBlockingStore;
import org.infinispan.persistence.support.SegmentPublisherWrapper;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class AsyncNonBlockingStore<K, V>
extends DelegatingNonBlockingStore<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final NonBlockingStore<K, V> actual;
    private Executor nonBlockingExecutor;
    private int segmentCount;
    private int modificationQueueSize;
    private PersistenceConfiguration persistenceConfiguration;
    private AsyncStoreConfiguration asyncConfiguration;
    private ScheduledExecutorService scheduler;
    @GuardedBy(value="this")
    private CompletableFuture<Void> batchFuture;
    @GuardedBy(value="this")
    private CompletableFuture<Void> delegateAvailableFuture;
    @GuardedBy(value="this")
    private Map<Object, Modification> pendingModifications = new HashMap<Object, Modification>();
    @GuardedBy(value="this")
    private boolean hasPendingClear;
    @GuardedBy(value="this")
    private Map<Object, Modification> replicatingModifications = Collections.emptyMap();
    @GuardedBy(value="this")
    private boolean isReplicatingClear;
    private volatile boolean stopped = true;

    public AsyncNonBlockingStore(NonBlockingStore<K, V> actual) {
        this.actual = actual;
    }

    @Override
    public CompletionStage<Void> start(InitializationContext ctx) {
        Configuration cacheConfiguration = ctx.getCache().getCacheConfiguration();
        this.persistenceConfiguration = cacheConfiguration.persistence();
        this.scheduler = ctx.getCache().getCacheManager().getGlobalComponentRegistry().getComponent(ScheduledExecutorService.class, "org.infinispan.executors.timeout");
        assert (this.scheduler != null);
        Object storeConfiguration = ctx.getConfiguration();
        this.segmentCount = storeConfiguration.segmented() ? cacheConfiguration.clustering().hash().numSegments() : 1;
        this.asyncConfiguration = storeConfiguration.async();
        this.modificationQueueSize = this.asyncConfiguration.modificationQueueSize();
        this.nonBlockingExecutor = ctx.getNonBlockingExecutor();
        this.stopped = false;
        return this.actual.start(ctx);
    }

    @Override
    public CompletionStage<Void> stop() {
        if (log.isTraceEnabled()) {
            log.tracef("Stopping async store containing store %s", this.actual);
        }
        CompletionStage<Void> asyncStage = this.awaitQuiescence();
        return asyncStage.thenCompose(ignore -> {
            if (log.isTraceEnabled()) {
                log.tracef("Stopping store %s from async store", this.actual);
            }
            this.stopped = true;
            return this.actual.stop();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> awaitQuiescence() {
        CompletableFuture<Void> stage;
        AsyncNonBlockingStore asyncNonBlockingStore = this;
        synchronized (asyncNonBlockingStore) {
            stage = this.batchFuture;
        }
        if (stage == null) {
            return CompletableFutures.completedNull();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Must wait until prior batch completes for %s", this.actual);
        }
        return stage.thenCompose(ignore -> this.awaitQuiescence());
    }

    void putModification(Object key, Modification modification) {
        this.pendingModifications.put(key, modification);
    }

    void putClearModification() {
        this.pendingModifications.clear();
        this.hasPendingClear = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitTask() {
        CompletionStage<Void> asyncBatchStage;
        boolean ourClearToReplicate;
        Map<Object, Modification> ourModificationsToReplicate;
        HashMap<Object, Modification> newMap = new HashMap<Object, Modification>();
        if (log.isTraceEnabled()) {
            log.tracef("Starting new batch with id %s", System.identityHashCode(newMap));
        }
        AsyncNonBlockingStore asyncNonBlockingStore = this;
        synchronized (asyncNonBlockingStore) {
            assert (this.replicatingModifications.isEmpty() && !this.isReplicatingClear);
            this.replicatingModifications = this.pendingModifications;
            ourModificationsToReplicate = this.pendingModifications;
            this.pendingModifications = newMap;
            this.isReplicatingClear = this.hasPendingClear;
            ourClearToReplicate = this.hasPendingClear;
            this.hasPendingClear = false;
        }
        if (ourClearToReplicate) {
            if (log.isTraceEnabled()) {
                log.tracef("Sending clear to underlying store for id %s", System.identityHashCode(ourModificationsToReplicate));
            }
            asyncBatchStage = this.retry(this.actual::clear, this.persistenceConfiguration.connectionAttempts()).whenComplete((ignore, t) -> {
                AsyncNonBlockingStore asyncNonBlockingStore = this;
                synchronized (asyncNonBlockingStore) {
                    this.isReplicatingClear = false;
                }
            });
        } else {
            asyncBatchStage = CompletableFutures.completedNull();
        }
        if (!ourModificationsToReplicate.isEmpty()) {
            asyncBatchStage = asyncBatchStage.thenCompose(ignore -> {
                if (log.isTraceEnabled()) {
                    log.tracef("Sending batch of %d write/remove operations to underlying store with id %s", ourModificationsToReplicate.size(), System.identityHashCode(ourModificationsToReplicate));
                }
                return this.retry(() -> this.replicateModifications(ourModificationsToReplicate), this.persistenceConfiguration.connectionAttempts()).whenComplete((ignore2, t) -> {
                    AsyncNonBlockingStore asyncNonBlockingStore = this;
                    synchronized (asyncNonBlockingStore) {
                        this.replicatingModifications = Collections.emptyMap();
                    }
                });
            });
        }
        asyncBatchStage.whenComplete((ignore, t) -> {
            CompletableFuture<Void> future;
            boolean submitNewBatch;
            if (log.isTraceEnabled()) {
                log.tracef("Async operations completed for id %s", System.identityHashCode(ourModificationsToReplicate));
            }
            AsyncNonBlockingStore asyncNonBlockingStore = this;
            synchronized (asyncNonBlockingStore) {
                submitNewBatch = !this.pendingModifications.isEmpty() || this.hasPendingClear;
                future = this.batchFuture;
                this.batchFuture = submitNewBatch ? new CompletableFuture() : null;
            }
            if (t != null) {
                future.completeExceptionally((Throwable)t);
            } else {
                future.complete(null);
            }
            if (submitNewBatch) {
                if (log.isTraceEnabled()) {
                    log.trace("Submitting new batch after completion of prior");
                }
                this.submitTask();
            }
        });
    }

    private CompletionStage<Void> retry(Supplier<CompletionStage<Void>> operationSupplier, int retries) {
        return CompletionStages.handleAndCompose(this.getAvailabilityDelayStage().thenCompose(ignore -> (CompletionStage)operationSupplier.get()), (ignore, throwable) -> {
            if (throwable != null) {
                if (retries > 0) {
                    int waitTime = this.persistenceConfiguration.availabilityInterval();
                    log.debugf((Throwable)throwable, "Failed to process async operation - retrying with delay of %d ms", waitTime);
                    if (waitTime > 0) {
                        RunnableCompletionStage rcs = new RunnableCompletionStage(() -> this.lambda$retry$8((Supplier)operationSupplier, retries));
                        this.scheduler.schedule(rcs, (long)waitTime, TimeUnit.MILLISECONDS);
                        return rcs;
                    }
                    return this.retry(operationSupplier, retries - 1);
                }
                log.debug("Failed to process async operation - no more retries", (Throwable)throwable);
                return CompletableFutures.completedExceptionFuture(throwable);
            }
            return CompletableFutures.completedNull();
        });
    }

    private CompletionStage<Void> replicateModifications(Map<Object, Modification> modifications) {
        ConnectableFlowable connectableModifications = Flowable.fromIterable(modifications.values()).publish();
        Flowable modificationFlowable = connectableModifications.autoConnect(2);
        return this.actual.batch(this.segmentCount, (Publisher<NonBlockingStore.SegmentedPublisher<Object>>)modificationFlowable.ofType(RemoveModification.class).groupBy(Modification::getSegment, RemoveModification::getKey).map(SegmentPublisherWrapper::wrap), (Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>>)modificationFlowable.ofType(PutModification.class).groupBy(Modification::getSegment, PutModification::getEntry).map(SegmentPublisherWrapper::wrap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> getAvailabilityDelayStage() {
        CompletableFuture<Void> availabilityFuture;
        if (this.asyncConfiguration.failSilently()) {
            return CompletableFutures.completedNull();
        }
        AsyncNonBlockingStore asyncNonBlockingStore = this;
        synchronized (asyncNonBlockingStore) {
            availabilityFuture = this.delegateAvailableFuture;
        }
        return availabilityFuture == null ? CompletableFutures.completedNull() : availabilityFuture;
    }

    @Override
    public Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        return Flowable.defer(() -> {
            this.assertNotStopped();
            if (log.isTraceEnabled()) {
                log.tracef("Publisher subscribed to retrieve entries for segments %s", segments);
            }
            return this.abstractPublish(segments, filter, PutModification::getEntry, MarshallableEntry::getKey, (innerSegments, predicate) -> this.actual.publishEntries((IntSet)innerSegments, (Predicate<K>)predicate, includeValues));
        });
    }

    @Override
    public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        return Flowable.defer(() -> {
            this.assertNotStopped();
            if (log.isTraceEnabled()) {
                log.tracef("Publisher subscribed to retrieve keys for segments %s", segments);
            }
            return this.abstractPublish(segments, filter, putModification -> putModification.getEntry().getKey(), RxJavaInterop.identityFunction(), this.actual::publishKeys);
        });
    }

    private <E> Publisher<E> abstractPublish(IntSet segments, Predicate<? super K> filter, Function<PutModification, E> putFunction, Function<E, K> toKeyFunction, BiFunction<IntSet, Predicate<K>, Publisher<E>> publisherFunction) {
        Map.Entry<Boolean, Map<Object, Modification>> entryModifications = this.flattenModificationMaps();
        Map<Object, Modification> modificationCopy = entryModifications.getValue();
        Flowable modPublisher = Flowable.fromIterable(modificationCopy.values()).ofType(PutModification.class).filter(modification -> segments.contains(modification.getSegment())).map(putFunction);
        if (filter != null) {
            modPublisher = modPublisher.filter(e -> filter.test((Object)toKeyFunction.apply(e)));
        }
        if (entryModifications.getKey().booleanValue()) {
            if (log.isTraceEnabled()) {
                log.trace("Only utilizing pending modifications as clear a was found");
            }
            return modPublisher;
        }
        Predicate<Object> combinedPredicate = k -> !modificationCopy.containsKey(k);
        if (filter != null) {
            combinedPredicate = combinedPredicate.and(filter);
        }
        return modPublisher.concatWith(publisherFunction.apply(segments, combinedPredicate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry<Boolean, Map<Object, Modification>> flattenModificationMaps() {
        boolean clearToReplicate;
        Map<Object, Modification> modificationsToReplicate;
        HashMap<Object, Modification> modificationCopy;
        AsyncNonBlockingStore asyncNonBlockingStore = this;
        synchronized (asyncNonBlockingStore) {
            modificationCopy = new HashMap<Object, Modification>(this.pendingModifications);
            if (this.hasPendingClear) {
                return new AbstractMap.SimpleImmutableEntry<Boolean, Map<Object, Modification>>(Boolean.TRUE, modificationCopy);
            }
            modificationsToReplicate = this.replicatingModifications;
            clearToReplicate = this.isReplicatingClear;
        }
        modificationCopy.putAll(modificationsToReplicate);
        return new AbstractMap.SimpleImmutableEntry<Boolean, Map<Object, Modification>>(clearToReplicate, modificationCopy);
    }

    @Override
    public CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
        this.assertNotStopped();
        CompletionStage<MarshallableEntry<K, V>> pendingStage = this.getStageFromPending(key);
        if (pendingStage != null) {
            return pendingStage;
        }
        return this.actual.load(segment, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<MarshallableEntry<K, V>> getStageFromPending(Object key) {
        boolean clearToReplicate;
        Map<Object, Modification> modificationsToReplicate;
        Object wrappedKey = AsyncNonBlockingStore.wrapKeyIfNeeded(key);
        AsyncNonBlockingStore asyncNonBlockingStore = this;
        synchronized (asyncNonBlockingStore) {
            Modification modification = this.pendingModifications.get(wrappedKey);
            if (modification != null) {
                if (log.isTraceEnabled()) {
                    log.tracef("Found entry was pending write in async store: %s", modification);
                }
                return modification.asStage();
            }
            if (this.hasPendingClear) {
                if (log.isTraceEnabled()) {
                    log.trace("There is a pending clear from async store, returning null");
                }
                return CompletableFutures.completedNull();
            }
            modificationsToReplicate = this.replicatingModifications;
            clearToReplicate = this.isReplicatingClear;
        }
        Modification modification = modificationsToReplicate.get(wrappedKey);
        if (modification != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Found entry was replicating write in async store: %s", modification);
            }
            return modification.asStage();
        }
        if (clearToReplicate) {
            if (log.isTraceEnabled()) {
                log.trace("There is a clear being replicated from async store, returning null");
            }
            return CompletableFutures.completedNull();
        }
        return null;
    }

    @Override
    public CompletionStage<Void> batch(int publisherCount, Publisher<NonBlockingStore.SegmentedPublisher<Object>> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        this.assertNotStopped();
        Completable removeCompletable = Flowable.fromPublisher(removePublisher).flatMapCompletable(sp -> Flowable.fromPublisher((Publisher)sp).concatMapCompletable(key -> Completable.fromCompletionStage(this.submitModification(new RemoveModification(sp.getSegment(), key))), publisherCount));
        Completable modifyCompletable = Flowable.fromPublisher(writePublisher).flatMapCompletable(sp -> Flowable.fromPublisher((Publisher)sp).concatMapCompletable(me -> Completable.fromCompletionStage(this.submitModification(new PutModification(sp.getSegment(), (MarshallableEntry)me))), publisherCount));
        return removeCompletable.mergeWith((CompletableSource)modifyCompletable).toCompletionStage(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletionStage<Void> submitModification(Modification modification) {
        CompletableFuture<Void> submitStage;
        boolean startNewBatch;
        boolean isTraceEnabled = log.isTraceEnabled();
        AsyncNonBlockingStore asyncNonBlockingStore = this;
        synchronized (asyncNonBlockingStore) {
            int queueSize;
            int previousBatchId;
            if (isTraceEnabled) {
                previousBatchId = System.identityHashCode(this.replicatingModifications);
                int currentBatchId = System.identityHashCode(this.pendingModifications);
                log.tracef("Adding modification %s to batch %s", modification, currentBatchId);
            } else {
                previousBatchId = 0;
            }
            modification.apply(this);
            boolean bl = startNewBatch = this.batchFuture == null;
            if (startNewBatch) {
                this.batchFuture = new CompletableFuture();
            }
            CompletableFuture<Void> completableFuture = submitStage = (queueSize = this.pendingModifications.size() + this.replicatingModifications.size()) > this.modificationQueueSize ? this.batchFuture : null;
            if (submitStage != null && isTraceEnabled) {
                log.tracef("Too many modifications queued (%d), operation must wait until previous batch %d completes", queueSize, previousBatchId);
            }
        }
        if (startNewBatch) {
            this.submitTask();
        }
        return submitStage == null ? CompletableFutures.completedNull() : submitStage.thenApplyAsync(CompletableFutures.toNullFunction(), this.nonBlockingExecutor);
    }

    @Override
    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        this.assertNotStopped();
        return this.submitModification(new PutModification(segment, entry));
    }

    @Override
    public CompletionStage<Boolean> delete(int segment, Object key) {
        this.assertNotStopped();
        return this.submitModification(new RemoveModification(segment, key));
    }

    @Override
    public CompletionStage<Void> clear() {
        this.assertNotStopped();
        this.submitModification(ClearModification.INSTANCE);
        return CompletableFutures.completedNull();
    }

    @Override
    public Publisher<MarshallableEntry<K, V>> purgeExpired() {
        return Flowable.defer(() -> {
            this.assertNotStopped();
            return this.actual.purgeExpired();
        });
    }

    @Override
    public CompletionStage<Void> addSegments(IntSet segments) {
        this.assertNotStopped();
        return this.actual.addSegments(segments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> removeSegments(IntSet segments) {
        this.assertNotStopped();
        AsyncNonBlockingStore asyncNonBlockingStore = this;
        synchronized (asyncNonBlockingStore) {
            this.pendingModifications.values().removeIf(modification -> segments.contains(modification.getSegment()));
        }
        return this.actual.removeSegments(segments);
    }

    @Override
    public CompletionStage<Long> size(IntSet segments) {
        this.assertNotStopped();
        return this.actual.size(segments);
    }

    @Override
    public CompletionStage<Long> approximateSize(IntSet segments) {
        this.assertNotStopped();
        return this.actual.approximateSize(segments);
    }

    @Override
    public CompletionStage<Boolean> isAvailable() {
        if (this.stopped) {
            return CompletableFutures.completedFalse();
        }
        if (this.asyncConfiguration.failSilently()) {
            return CompletableFutures.completedTrue();
        }
        CompletionStage<Boolean> superAvailableStage = super.isAvailable();
        return superAvailableStage.thenApply(delegateAvailable -> {
            boolean delegateUnavailable;
            int queueSize;
            boolean isReplicating;
            if (delegateAvailable.booleanValue()) {
                CompletableFuture<Void> delegateFuture;
                AsyncNonBlockingStore asyncNonBlockingStore = this;
                synchronized (asyncNonBlockingStore) {
                    delegateFuture = this.delegateAvailableFuture;
                    this.delegateAvailableFuture = null;
                }
                if (delegateFuture != null) {
                    log.debugf("Underlying delegate %s is now available", this.actual);
                    delegateFuture.complete(null);
                }
                return true;
            }
            AsyncNonBlockingStore asyncNonBlockingStore = this;
            synchronized (asyncNonBlockingStore) {
                isReplicating = !this.replicatingModifications.isEmpty() || this.isReplicatingClear;
                queueSize = this.pendingModifications.size();
                delegateUnavailable = this.delegateAvailableFuture == null;
                if (delegateUnavailable) {
                    this.delegateAvailableFuture = new CompletableFuture();
                }
            }
            if (delegateUnavailable) {
                log.debugf("Underlying delegate %s is now unavailable!", this.actual);
            }
            return queueSize < this.modificationQueueSize || !isReplicating;
        });
    }

    @Override
    public NonBlockingStore<K, V> delegate() {
        return this.actual;
    }

    private void assertNotStopped() throws CacheException {
        if (this.stopped) {
            throw new IllegalLifecycleStateException("AsyncCacheWriter stopped; no longer accepting more entries.");
        }
    }

    static Object wrapKeyIfNeeded(Object key) {
        if (key instanceof byte[]) {
            return new WrappedByteArray((byte[])key);
        }
        return key;
    }

    private /* synthetic */ CompletionStage lambda$retry$8(Supplier operationSupplier, int retries) {
        return this.retry(operationSupplier, retries - 1);
    }

    private static class RunnableCompletionStage
    extends CompletableFuture<Void>
    implements Runnable {
        private final Supplier<CompletionStage<Void>> supplier;

        private RunnableCompletionStage(Supplier<CompletionStage<Void>> supplier) {
            this.supplier = supplier;
        }

        @Override
        public void run() {
            this.supplier.get().whenComplete((? super T ignore, ? super Throwable throwable) -> {
                if (throwable != null) {
                    this.completeExceptionally((Throwable)throwable);
                } else {
                    this.complete(null);
                }
            });
        }
    }
}

