/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.globalstate.impl;

import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.globalstate.LocalConfigurationStorage;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.globalstate.impl.CacheState;
import org.infinispan.globalstate.impl.GlobalConfigurationStateListener;
import org.infinispan.globalstate.impl.ImmutableLocalConfigurationStorage;
import org.infinispan.globalstate.impl.OverlayLocalConfigurationStorage;
import org.infinispan.globalstate.impl.SecurityActions;
import org.infinispan.globalstate.impl.VolatileLocalConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.event.ConfigurationChangedEvent;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class GlobalConfigurationManagerImpl
implements GlobalConfigurationManager {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    public static final String CACHE_SCOPE = "cache";
    public static final String TEMPLATE_SCOPE = "template";
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    LocalTopologyManager localTopologyManager;
    @Inject
    ConfigurationManager configurationManager;
    @Inject
    InternalCacheRegistry internalCacheRegistry;
    @Inject
    GlobalComponentRegistry globalComponentRegistry;
    @Inject
    BlockingManager blockingManager;
    @Inject
    CacheManagerNotifier cacheManagerNotifier;
    private Cache<ScopedState, Object> stateCache;
    private ParserRegistry parserRegistry;
    private LocalConfigurationStorage localConfigurationManager;

    static boolean isKnownScope(String scope) {
        return CACHE_SCOPE.equals(scope) || TEMPLATE_SCOPE.equals(scope);
    }

    @Start
    void start() {
        switch (this.configurationManager.getGlobalConfiguration().globalState().configurationStorage()) {
            case IMMUTABLE: {
                this.localConfigurationManager = new ImmutableLocalConfigurationStorage();
                break;
            }
            case VOLATILE: {
                this.localConfigurationManager = new VolatileLocalConfigurationStorage();
                break;
            }
            case OVERLAY: {
                this.localConfigurationManager = new OverlayLocalConfigurationStorage();
                break;
            }
            default: {
                this.localConfigurationManager = this.configurationManager.getGlobalConfiguration().globalState().configurationStorageClass().get();
            }
        }
        this.internalCacheRegistry.registerInternalCache("org.infinispan.CONFIG", new ConfigurationBuilder().build(), EnumSet.of(InternalCacheRegistry.Flag.GLOBAL));
        this.parserRegistry = new ParserRegistry();
        HashSet<String> staticCacheNames = new HashSet<String>(this.configurationManager.getDefinedCaches());
        log.debugf("Starting statically defined caches: %s", staticCacheNames);
        for (String cacheName : this.configurationManager.getDefinedCaches()) {
            SecurityActions.getCache(this.cacheManager, cacheName);
        }
        this.localConfigurationManager.initialize(this.cacheManager, this.configurationManager, this.blockingManager);
        GlobalConfigurationStateListener stateCacheListener = new GlobalConfigurationStateListener(this);
        this.getStateCache().addListener(stateCacheListener);
        Map<String, Configuration> persistedCaches = this.localConfigurationManager.loadAllCaches();
        Map<String, Configuration> persistedTemplates = this.localConfigurationManager.loadAllTemplates();
        this.getStateCache().forEach((key, v) -> {
            String scope = key.getScope();
            if (GlobalConfigurationManagerImpl.isKnownScope(scope)) {
                String name = key.getName();
                CacheState state = (CacheState)v;
                boolean cacheScope = CACHE_SCOPE.equals(scope);
                Map map = cacheScope ? persistedCaches : persistedTemplates;
                this.ensureClusterCompatibility(name, state, map);
                CompletionStage<Void> future = cacheScope ? this.createCacheLocally(name, state) : this.createTemplateLocally(name, state);
                CompletionStages.join(future);
            }
        });
        EnumSet<CacheContainerAdmin.AdminFlag> adminFlags = EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class);
        persistedCaches.forEach((name, configuration) -> {
            this.ensurePersistenceCompatibility((String)name, (Configuration)((Object)configuration), persistedCaches);
            this.createCacheLocally((String)name, null, (Configuration)((Object)configuration), adminFlags);
            CompletionStages.join(this.getOrCreateCache((String)name, (Configuration)((Object)configuration), adminFlags));
        });
        persistedTemplates.forEach((name, configuration) -> {
            this.ensurePersistenceCompatibility((String)name, (Configuration)((Object)configuration), persistedTemplates);
            this.createTemplateLocally((String)name, (Configuration)((Object)configuration), adminFlags);
            CompletionStages.join(this.getOrCreateTemplate((String)name, (Configuration)((Object)configuration), adminFlags));
        });
    }

    private void ensureClusterCompatibility(String name, CacheState state, Map<String, Configuration> configs) {
        Configuration persisted = configs.get(name);
        if (persisted != null) {
            Configuration configuration = this.buildConfiguration(name, state.getConfiguration(), false);
            if (!persisted.matches(configuration)) {
                throw Log.CONFIG.incompatibleClusterConfiguration(name, configuration, persisted);
            }
            configs.remove(name);
        }
    }

    private void ensurePersistenceCompatibility(String name, Configuration configuration, Map<String, Configuration> configs) {
        Configuration staticConfiguration = this.cacheManager.getCacheConfiguration(name);
        if (staticConfiguration != null) {
            if (!staticConfiguration.matches(configuration)) {
                throw Log.CONFIG.incompatiblePersistedConfiguration(name, configuration, staticConfiguration);
            }
            configs.remove(name);
        }
    }

    @Override
    public Cache<ScopedState, Object> getStateCache() {
        if (this.stateCache == null) {
            this.stateCache = this.cacheManager.getCache("org.infinispan.CONFIG");
        }
        return this.stateCache;
    }

    @Override
    public CompletionStage<Void> createTemplate(String name, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Cache<ScopedState, Object> cache = this.getStateCache();
        ScopedState key = new ScopedState(TEMPLATE_SCOPE, name);
        return ((CompletableFuture)cache.containsKeyAsync(key).thenCompose(exists -> {
            if (exists.booleanValue()) {
                throw Log.CONFIG.configAlreadyDefined(name);
            }
            return cache.putAsync(key, new CacheState(null, this.parserRegistry.serialize(name, configuration), flags));
        })).thenApply(v -> null);
    }

    @Override
    public CompletionStage<Configuration> getOrCreateTemplate(String name, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        this.localConfigurationManager.validateFlags(flags);
        try {
            CacheState state = new CacheState(null, this.parserRegistry.serialize(name, configuration), flags);
            return this.getStateCache().putIfAbsentAsync(new ScopedState(TEMPLATE_SCOPE, name), state).thenApply(v -> configuration);
        }
        catch (Exception e) {
            throw Log.CONFIG.configurationSerializationFailed(name, configuration, e);
        }
    }

    @Override
    public CompletionStage<Configuration> createCache(String cacheName, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (this.cacheManager.cacheExists(cacheName)) {
            throw Log.CONFIG.cacheExists(cacheName);
        }
        return this.getOrCreateCache(cacheName, configuration, flags);
    }

    @Override
    public CompletionStage<Configuration> getOrCreateCache(String cacheName, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        return this.createCache(cacheName, null, configuration, flags);
    }

    @Override
    public CompletionStage<Configuration> createCache(String cacheName, String template, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        if (this.cacheManager.cacheExists(cacheName)) {
            throw Log.CONFIG.cacheExists(cacheName);
        }
        return this.getOrCreateCache(cacheName, template, flags);
    }

    @Override
    public CompletionStage<Configuration> getOrCreateCache(String cacheName, String template, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration configuration;
        if (template == null) {
            if (this.cacheManager.cacheExists(cacheName)) {
                return CompletableFuture.completedFuture(this.configurationManager.getConfiguration(cacheName, true));
            }
            Optional<String> defaultCacheName = this.configurationManager.getGlobalConfiguration().defaultCacheName();
            configuration = defaultCacheName.isPresent() ? this.configurationManager.getConfiguration(defaultCacheName.get(), true) : null;
            if (configuration == null) {
                configuration = new ConfigurationBuilder().build();
            }
        } else {
            configuration = this.configurationManager.getConfiguration(template, true);
            if (configuration == null) {
                throw Log.CONFIG.undeclaredConfiguration(template, cacheName);
            }
        }
        return this.createCache(cacheName, template, configuration, flags);
    }

    CompletionStage<Configuration> createCache(String cacheName, String template, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        CacheState state;
        this.localConfigurationManager.validateFlags(flags);
        try {
            state = new CacheState(template, this.parserRegistry.serialize(cacheName, configuration), flags);
        }
        catch (Exception e) {
            throw Log.CONFIG.configurationSerializationFailed(cacheName, configuration, e);
        }
        if (flags.contains(CacheContainerAdmin.AdminFlag.UPDATE)) {
            if (this.internalCacheRegistry.isInternalCache(cacheName)) {
                throw Log.CONFIG.cannotUpdateInternalCache(cacheName);
            }
            return this.getStateCache().putAsync(new ScopedState(CACHE_SCOPE, cacheName), state).thenApply(v -> configuration);
        }
        return this.getStateCache().putIfAbsentAsync(new ScopedState(CACHE_SCOPE, cacheName), state).thenApply(v -> configuration);
    }

    CompletionStage<Void> createTemplateLocally(String name, CacheState state) {
        Configuration configuration = this.buildConfiguration(name, state.getConfiguration(), true);
        return this.createTemplateLocally(name, configuration, state.getFlags());
    }

    CompletionStage<Void> createTemplateLocally(String name, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        log.debugf("Creating template %s from global state", name);
        return this.localConfigurationManager.createTemplate(name, configuration, flags).thenCompose(v -> this.cacheManagerNotifier.notifyConfigurationChanged(ConfigurationChangedEvent.EventType.CREATE, TEMPLATE_SCOPE, name)).toCompletableFuture();
    }

    CompletionStage<Void> createCacheLocally(String name, CacheState state) {
        Configuration configuration = this.buildConfiguration(name, state.getConfiguration(), false);
        return this.createCacheLocally(name, state.getTemplate(), configuration, state.getFlags());
    }

    CompletionStage<Void> createCacheLocally(String name, String template, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        log.debugf("Creating cache %s from global state", name);
        return this.localConfigurationManager.createCache(name, template, configuration, flags).thenCompose(v -> this.cacheManagerNotifier.notifyConfigurationChanged(ConfigurationChangedEvent.EventType.CREATE, CACHE_SCOPE, name)).toCompletableFuture();
    }

    CompletionStage<Void> validateConfigurationUpdateLocally(String name, CacheState state) {
        log.debugf("Validating configuration %s from global state", name);
        Configuration configuration = this.buildConfiguration(name, state.getConfiguration(), false);
        return this.localConfigurationManager.validateConfigurationUpdate(name, configuration, state.getFlags());
    }

    CompletionStage<Void> updateConfigurationLocally(String name, CacheState state) {
        log.debugf("Updating configuration %s from global state", name);
        Configuration configuration = this.buildConfiguration(name, state.getConfiguration(), false);
        return this.localConfigurationManager.updateConfiguration(name, configuration, state.getFlags()).thenCompose(v -> this.cacheManagerNotifier.notifyConfigurationChanged(ConfigurationChangedEvent.EventType.UPDATE, CACHE_SCOPE, name));
    }

    private Configuration buildConfiguration(String name, String configStr, boolean template) {
        ConfigurationBuilderHolder builderHolder = this.parserRegistry.parse(configStr);
        return builderHolder.getNamedConfigurationBuilders().get(name).template(template).build(this.configurationManager.getGlobalConfiguration());
    }

    @Override
    public CompletionStage<Void> removeCache(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        ScopedState cacheScopedState = new ScopedState(CACHE_SCOPE, name);
        if (this.getStateCache().containsKey(cacheScopedState)) {
            try {
                this.localTopologyManager.setCacheRebalancingEnabled(name, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.getStateCache().removeAsync(cacheScopedState).thenCompose(r -> CompletableFutures.completedNull());
        }
        return this.localConfigurationManager.removeCache(name, flags);
    }

    @Override
    public CompletionStage<Void> removeTemplate(String name, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        return this.getStateCache().removeAsync(new ScopedState(TEMPLATE_SCOPE, name)).thenCompose(r -> CompletableFutures.completedNull());
    }

    CompletionStage<Void> removeCacheLocally(String name, CacheState state) {
        return this.localConfigurationManager.removeCache(name, state.getFlags()).thenCompose(v -> this.cacheManagerNotifier.notifyConfigurationChanged(ConfigurationChangedEvent.EventType.REMOVE, CACHE_SCOPE, name));
    }

    CompletionStage<Void> removeTemplateLocally(String name, CacheState state) {
        return this.localConfigurationManager.removeTemplate(name, state.getFlags()).thenCompose(v -> this.cacheManagerNotifier.notifyConfigurationChanged(ConfigurationChangedEvent.EventType.REMOVE, TEMPLATE_SCOPE, name));
    }
}

