/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class DescriptorUtils {
    private static final Class<?>[] PRIMITIVES = new Class[]{Byte.TYPE, Boolean.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};

    public static String methodSignatureToDescriptor(String returnType, String ... params) {
        StringBuilder sb = new StringBuilder("(");
        for (String i : params) {
            sb.append(i);
        }
        sb.append(")");
        sb.append(returnType);
        return sb.toString();
    }

    public static String getTypeStringFromDescriptorFormat(String descriptor) {
        if (descriptor.startsWith("[")) {
            return descriptor;
        }
        descriptor = descriptor.substring(1);
        descriptor = descriptor.substring(0, descriptor.length() - 1);
        return descriptor;
    }

    public static String classToStringRepresentation(Class<?> c) {
        if (Void.TYPE.equals(c)) {
            return "V";
        }
        if (Byte.TYPE.equals(c)) {
            return "B";
        }
        if (Character.TYPE.equals(c)) {
            return "C";
        }
        if (Double.TYPE.equals(c)) {
            return "D";
        }
        if (Float.TYPE.equals(c)) {
            return "F";
        }
        if (Integer.TYPE.equals(c)) {
            return "I";
        }
        if (Long.TYPE.equals(c)) {
            return "J";
        }
        if (Short.TYPE.equals(c)) {
            return "S";
        }
        if (Boolean.TYPE.equals(c)) {
            return "Z";
        }
        if (c.isArray()) {
            return c.getName().replace('.', '/');
        }
        return DescriptorUtils.extToInt(c.getName());
    }

    public static String extToInt(String className) {
        String repl = className.replace('.', '/');
        return 'L' + repl + ';';
    }

    public static boolean isPrimitive(String descriptor) {
        return descriptor.length() == 1;
    }

    public static boolean isWide(String descriptor) {
        if (!DescriptorUtils.isPrimitive(descriptor)) {
            return false;
        }
        char c = descriptor.charAt(0);
        return c == 'D' || c == 'J';
    }

    public static String objectToDescriptor(Object param) {
        if (param instanceof String) {
            String s = (String)param;
            if (s.length() == 1) {
                return s;
            }
            if (s.startsWith("[")) {
                return s.replace('.', '/');
            }
            if (s.endsWith(";")) {
                return s;
            }
            for (Class<?> prim : PRIMITIVES) {
                if (!s.equals(prim.getName())) continue;
                return DescriptorUtils.classToStringRepresentation(prim);
            }
            return "L" + s.replace('.', '/') + ';';
        }
        if (param instanceof Class) {
            return DescriptorUtils.classToStringRepresentation((Class)param);
        }
        throw new IllegalArgumentException("Must be a Class or String, got " + param);
    }

    public static String[] objectsToDescriptor(Object[] param) {
        String[] ret = new String[param.length];
        for (int i = 0; i < param.length; ++i) {
            ret[i] = DescriptorUtils.objectToDescriptor(param[i]);
        }
        return ret;
    }

    public static String objectToInternalClassName(Object param) {
        if (param instanceof String) {
            String s = (String)param;
            return s.replace('.', '/');
        }
        if (param instanceof Class) {
            return ((Class)param).getName().replace('.', '/');
        }
        throw new IllegalArgumentException("Must be a Class or String, got " + param);
    }

    public static String typeToString(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            PrimitiveType.Primitive primitive = type.asPrimitiveType().primitive();
            switch (primitive) {
                case INT: {
                    return "I";
                }
                case BYTE: {
                    return "B";
                }
                case CHAR: {
                    return "C";
                }
                case LONG: {
                    return "J";
                }
                case FLOAT: {
                    return "F";
                }
                case SHORT: {
                    return "S";
                }
                case DOUBLE: {
                    return "D";
                }
                case BOOLEAN: {
                    return "Z";
                }
            }
            throw new RuntimeException("Unkown primitive type " + primitive);
        }
        if (type.kind() == Type.Kind.VOID) {
            return "V";
        }
        if (type.kind() == Type.Kind.ARRAY) {
            ArrayType array = type.asArrayType();
            return array.name().toString().replace('.', '/');
        }
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType pt = type.asParameterizedType();
            StringBuilder ret = new StringBuilder();
            ret.append("L");
            ret.append(pt.name().toString().replace('.', '/'));
            ret.append(";");
            return ret.toString();
        }
        if (type.kind() == Type.Kind.CLASS) {
            ClassType pt = type.asClassType();
            StringBuilder ret = new StringBuilder();
            ret.append("L");
            ret.append(pt.name().toString().replace('.', '/'));
            ret.append(";");
            return ret.toString();
        }
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            TypeVariable pt = type.asTypeVariable();
            StringBuilder ret = new StringBuilder();
            ret.append("L");
            ret.append(pt.name().toString().replace('.', '/'));
            ret.append(";");
            return ret.toString();
        }
        throw new RuntimeException("Invalid type for descriptor " + type);
    }
}

