/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.secretengine;

import io.quarkus.vault.runtime.client.VaultInternalBase;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitCreateKeyBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitDecrypt;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitDecryptBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitEncrypt;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitEncryptBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitKeyConfigBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitKeyExport;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitListKeysResult;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitReadKeyResult;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitRewrapBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitSign;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitSignBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitVerify;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitVerifyBody;
import javax.inject.Singleton;

@Singleton
public class VaultInternalTransitSecretEngine
extends VaultInternalBase {
    public void updateTransitKeyConfiguration(String token, String keyName, VaultTransitKeyConfigBody body) {
        this.vaultClient.post("transit/keys/" + keyName + "/config", token, (Object)body, 204);
    }

    public void createTransitKey(String token, String keyName, VaultTransitCreateKeyBody body) {
        this.vaultClient.post("transit/keys/" + keyName, token, (Object)body, 204);
    }

    public void deleteTransitKey(String token, String keyName) {
        this.vaultClient.delete("transit/keys/" + keyName, token, 204);
    }

    public VaultTransitKeyExport exportTransitKey(String token, String keyType, String keyName, String version) {
        String path = "transit/export/" + keyType + "/" + keyName + (String)(version != null ? "/" + version : "");
        return this.vaultClient.get(path, token, VaultTransitKeyExport.class);
    }

    public VaultTransitReadKeyResult readTransitKey(String token, String keyName) {
        return this.vaultClient.get("transit/keys/" + keyName, token, VaultTransitReadKeyResult.class);
    }

    public VaultTransitListKeysResult listTransitKeys(String token) {
        return this.vaultClient.list("transit/keys", token, VaultTransitListKeysResult.class);
    }

    public VaultTransitEncrypt encrypt(String token, String keyName, VaultTransitEncryptBody body) {
        return this.vaultClient.post("transit/encrypt/" + keyName, token, (Object)body, VaultTransitEncrypt.class);
    }

    public VaultTransitDecrypt decrypt(String token, String keyName, VaultTransitDecryptBody body) {
        return this.vaultClient.post("transit/decrypt/" + keyName, token, (Object)body, VaultTransitDecrypt.class);
    }

    public VaultTransitSign sign(String token, String keyName, String hashAlgorithm, VaultTransitSignBody body) {
        String path = "transit/sign/" + keyName + (String)(hashAlgorithm == null ? "" : "/" + hashAlgorithm);
        return this.vaultClient.post(path, token, (Object)body, VaultTransitSign.class);
    }

    public VaultTransitVerify verify(String token, String keyName, String hashAlgorithm, VaultTransitVerifyBody body) {
        String path = "transit/verify/" + keyName + (String)(hashAlgorithm == null ? "" : "/" + hashAlgorithm);
        return this.vaultClient.post(path, token, (Object)body, VaultTransitVerify.class);
    }

    public VaultTransitEncrypt rewrap(String token, String keyName, VaultTransitRewrapBody body) {
        return this.vaultClient.post("transit/rewrap/" + keyName, token, (Object)body, VaultTransitEncrypt.class);
    }
}

