/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.authmethod;

import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.client.VaultInternalBase;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuth;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthBody;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthConfigData;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthConfigResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthListRolesResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthReadRoleResult;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthRoleData;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class VaultInternalKubernetesAuthMethod
extends VaultInternalBase {
    @Inject
    private VaultConfigHolder vaultConfigHolder;

    private String getKubernetesAuthMountPath() {
        return this.vaultConfigHolder.getVaultBootstrapConfig().authentication.kubernetes.authMountPath;
    }

    public VaultKubernetesAuth login(String role, String jwt) {
        VaultKubernetesAuthBody body = new VaultKubernetesAuthBody(role, jwt);
        return this.vaultClient.post(this.getKubernetesAuthMountPath() + "/login", null, (Object)body, VaultKubernetesAuth.class);
    }

    public void createAuthRole(String token, String name, VaultKubernetesAuthRoleData body) {
        this.vaultClient.post(this.getKubernetesAuthMountPath() + "/role/" + name, token, (Object)body, 204);
    }

    public VaultKubernetesAuthReadRoleResult getVaultAuthRole(String token, String name) {
        return this.vaultClient.get(this.getKubernetesAuthMountPath() + "/role/" + name, token, VaultKubernetesAuthReadRoleResult.class);
    }

    public VaultKubernetesAuthListRolesResult listAuthRoles(String token) {
        return this.vaultClient.list(this.getKubernetesAuthMountPath() + "/role", token, VaultKubernetesAuthListRolesResult.class);
    }

    public void deleteAuthRoles(String token, String name) {
        this.vaultClient.delete(this.getKubernetesAuthMountPath() + "/role/" + name, token, 204);
    }

    public void configureAuth(String token, VaultKubernetesAuthConfigData config) {
        this.vaultClient.post(this.getKubernetesAuthMountPath() + "/config", token, (Object)config, 204);
    }

    public VaultKubernetesAuthConfigResult readAuthConfig(String token) {
        return this.vaultClient.get(this.getKubernetesAuthMountPath() + "/config", token, VaultKubernetesAuthConfigResult.class);
    }

    public VaultInternalKubernetesAuthMethod setVaultConfigHolder(VaultConfigHolder vaultConfigHolder) {
        this.vaultConfigHolder = vaultConfigHolder;
        return this;
    }
}

